/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.ListSerializer;
import org.opendaylight.openflowjava.protocol.impl.util.TypeKeyMaker;
import org.opendaylight.openflowjava.protocol.impl.util.TypeKeyMakerFactory;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.ActionChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.CopyTtlInCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.CopyTtlOutCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.DecMplsTtlCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.DecNwTtlCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.GroupCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.OutputActionCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.PopMplsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.PopPbbCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.PopVlanCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.PushMplsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.PushPbbCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.PushVlanCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.SetFieldCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.SetMplsTtlCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.SetNwTtlCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.SetQueueCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.group._case.GroupActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.output.action._case.OutputActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.pop.mpls._case.PopMplsActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.push.mpls._case.PushMplsActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.push.pbb._case.PushPbbActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.push.vlan._case.PushVlanActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.set.field._case.SetFieldActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.set.mpls.ttl._case.SetMplsTtlActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.set.nw.ttl._case.SetNwTtlActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.set.queue._case.SetQueueActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.ActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.EtherType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.InPort;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OpenflowBasicClass;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.MatchEntryValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.InPortCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.in.port._case.InPortBuilder;

public class OF13ActionsSerializerTest {
    private SerializerRegistry registry;

    @Before
    public void startUp() {
        this.registry = new SerializerRegistryImpl();
        this.registry.init();
    }

    @Test
    public void test() {
        ArrayList<Action> actions = new ArrayList<Action>();
        ActionBuilder actionBuilder = new ActionBuilder();
        OutputActionCaseBuilder caseBuilder = new OutputActionCaseBuilder();
        OutputActionBuilder outputBuilder = new OutputActionBuilder();
        outputBuilder.setPort(new PortNumber(Long.valueOf(42L)));
        outputBuilder.setMaxLength(Integer.valueOf(52));
        caseBuilder.setOutputAction(outputBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)caseBuilder.build());
        actions.add(actionBuilder.build());
        actionBuilder = new ActionBuilder();
        actionBuilder.setActionChoice((ActionChoice)new CopyTtlOutCaseBuilder().build());
        actions.add(actionBuilder.build());
        actionBuilder = new ActionBuilder();
        actionBuilder.setActionChoice((ActionChoice)new CopyTtlInCaseBuilder().build());
        actions.add(actionBuilder.build());
        actionBuilder = new ActionBuilder();
        SetMplsTtlCaseBuilder setMplsTtlCaseBuilder = new SetMplsTtlCaseBuilder();
        SetMplsTtlActionBuilder setMplsTtlBuilder = new SetMplsTtlActionBuilder();
        setMplsTtlBuilder.setMplsTtl(Short.valueOf((short)4));
        setMplsTtlCaseBuilder.setSetMplsTtlAction(setMplsTtlBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)setMplsTtlCaseBuilder.build());
        actions.add(actionBuilder.build());
        actionBuilder = new ActionBuilder();
        actionBuilder.setActionChoice((ActionChoice)new DecMplsTtlCaseBuilder().build());
        actions.add(actionBuilder.build());
        actionBuilder = new ActionBuilder();
        PushVlanCaseBuilder pushVlanCaseBuilder = new PushVlanCaseBuilder();
        PushVlanActionBuilder pushVlanBuilder = new PushVlanActionBuilder();
        pushVlanBuilder.setEthertype(new EtherType(new EtherType(Integer.valueOf(16))));
        pushVlanCaseBuilder.setPushVlanAction(pushVlanBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)pushVlanCaseBuilder.build());
        actions.add(actionBuilder.build());
        actionBuilder = new ActionBuilder();
        actionBuilder.setActionChoice((ActionChoice)new PopVlanCaseBuilder().build());
        actions.add(actionBuilder.build());
        actionBuilder = new ActionBuilder();
        PushMplsCaseBuilder pushMplsCaseBuilder = new PushMplsCaseBuilder();
        PushMplsActionBuilder pushMplsBuilder = new PushMplsActionBuilder();
        pushMplsBuilder.setEthertype(new EtherType(new EtherType(Integer.valueOf(17))));
        pushMplsCaseBuilder.setPushMplsAction(pushMplsBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)pushMplsCaseBuilder.build());
        actions.add(actionBuilder.build());
        actionBuilder = new ActionBuilder();
        PopMplsCaseBuilder popMplsCaseBuilder = new PopMplsCaseBuilder();
        PopMplsActionBuilder popMplsBuilder = new PopMplsActionBuilder();
        popMplsBuilder.setEthertype(new EtherType(new EtherType(Integer.valueOf(18))));
        popMplsCaseBuilder.setPopMplsAction(popMplsBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)popMplsCaseBuilder.build());
        actions.add(actionBuilder.build());
        actionBuilder = new ActionBuilder();
        SetQueueCaseBuilder setQueueCaseBuilder = new SetQueueCaseBuilder();
        SetQueueActionBuilder setQueueBuilder = new SetQueueActionBuilder();
        setQueueBuilder.setQueueId(Long.valueOf(1234L));
        setQueueCaseBuilder.setSetQueueAction(setQueueBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)setQueueCaseBuilder.build());
        actions.add(actionBuilder.build());
        actionBuilder = new ActionBuilder();
        GroupCaseBuilder groupCaseBuilder = new GroupCaseBuilder();
        GroupActionBuilder groupActionBuilder = new GroupActionBuilder();
        groupActionBuilder.setGroupId(Long.valueOf(555L));
        groupCaseBuilder.setGroupAction(groupActionBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)groupCaseBuilder.build());
        actions.add(actionBuilder.build());
        actionBuilder = new ActionBuilder();
        SetNwTtlCaseBuilder nwTtlCaseBuilder = new SetNwTtlCaseBuilder();
        SetNwTtlActionBuilder nwTtlBuilder = new SetNwTtlActionBuilder();
        nwTtlBuilder.setNwTtl(Short.valueOf((short)8));
        nwTtlCaseBuilder.setSetNwTtlAction(nwTtlBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)nwTtlCaseBuilder.build());
        actions.add(actionBuilder.build());
        actionBuilder = new ActionBuilder();
        actionBuilder.setActionChoice((ActionChoice)new DecNwTtlCaseBuilder().build());
        actions.add(actionBuilder.build());
        actionBuilder = new ActionBuilder();
        SetFieldCaseBuilder setFieldCaseBuilder = new SetFieldCaseBuilder();
        SetFieldActionBuilder setFieldBuilder = new SetFieldActionBuilder();
        ArrayList<MatchEntry> entries = new ArrayList<MatchEntry>();
        MatchEntryBuilder matchBuilder = new MatchEntryBuilder();
        matchBuilder.setOxmClass(OpenflowBasicClass.class);
        matchBuilder.setOxmMatchField(InPort.class);
        matchBuilder.setHasMask(Boolean.valueOf(false));
        InPortCaseBuilder inPortCaseBuilder = new InPortCaseBuilder();
        InPortBuilder inPortBuilder = new InPortBuilder();
        inPortBuilder.setPortNumber(new PortNumber(Long.valueOf(1L)));
        inPortCaseBuilder.setInPort(inPortBuilder.build());
        matchBuilder.setMatchEntryValue((MatchEntryValue)inPortCaseBuilder.build());
        entries.add(matchBuilder.build());
        setFieldBuilder.setMatchEntry(entries);
        setFieldCaseBuilder.setSetFieldAction(setFieldBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)setFieldCaseBuilder.build());
        actions.add(actionBuilder.build());
        actionBuilder = new ActionBuilder();
        PushPbbCaseBuilder pushPbbCaseBuilder = new PushPbbCaseBuilder();
        PushPbbActionBuilder pushPbbBuilder = new PushPbbActionBuilder();
        pushPbbBuilder.setEthertype(new EtherType(new EtherType(Integer.valueOf(19))));
        pushPbbCaseBuilder.setPushPbbAction(pushPbbBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)pushPbbCaseBuilder.build());
        actions.add(actionBuilder.build());
        actionBuilder = new ActionBuilder();
        actionBuilder.setActionChoice((ActionChoice)new PopPbbCaseBuilder().build());
        actions.add(actionBuilder.build());
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        ListSerializer.serializeList(actions, (TypeKeyMaker)TypeKeyMakerFactory.createActionKeyMaker((short)4), (SerializerRegistry)this.registry, (ByteBuf)out);
        Assert.assertEquals((String)"Wrong action type", (long)0L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action length", (long)16L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action port", (long)42L, (long)out.readUnsignedInt());
        Assert.assertEquals((String)"Wrong action max-length", (long)52L, (long)out.readUnsignedShort());
        out.skipBytes(6);
        Assert.assertEquals((String)"Wrong action type", (long)11L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action length", (long)8L, (long)out.readUnsignedShort());
        out.skipBytes(4);
        Assert.assertEquals((String)"Wrong action type", (long)12L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action length", (long)8L, (long)out.readUnsignedShort());
        out.skipBytes(4);
        Assert.assertEquals((String)"Wrong action type", (long)15L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action length", (long)8L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action mpls-ttl", (long)4L, (long)out.readUnsignedByte());
        out.skipBytes(3);
        Assert.assertEquals((String)"Wrong action type", (long)16L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action length", (long)8L, (long)out.readUnsignedShort());
        out.skipBytes(4);
        Assert.assertEquals((String)"Wrong action type", (long)17L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action length", (long)8L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action ethertype", (long)16L, (long)out.readUnsignedShort());
        out.skipBytes(2);
        Assert.assertEquals((String)"Wrong action type", (long)18L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action length", (long)8L, (long)out.readUnsignedShort());
        out.skipBytes(4);
        Assert.assertEquals((String)"Wrong action type", (long)19L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action length", (long)8L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action ethertype", (long)17L, (long)out.readUnsignedShort());
        out.skipBytes(2);
        Assert.assertEquals((String)"Wrong action type", (long)20L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action length", (long)8L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action ethertype", (long)18L, (long)out.readUnsignedShort());
        out.skipBytes(2);
        Assert.assertEquals((String)"Wrong action type", (long)21L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action length", (long)8L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action queue-id", (long)1234L, (long)out.readUnsignedInt());
        Assert.assertEquals((String)"Wrong action type", (long)22L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action length", (long)8L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action group", (long)555L, (long)out.readUnsignedInt());
        Assert.assertEquals((String)"Wrong action type", (long)23L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action length", (long)8L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action nw-ttl", (long)8L, (long)out.readUnsignedByte());
        out.skipBytes(3);
        Assert.assertEquals((String)"Wrong action type", (long)24L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action length", (long)8L, (long)out.readUnsignedShort());
        out.skipBytes(4);
        Assert.assertEquals((String)"Wrong action type", (long)25L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action length", (long)16L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry field & mask", (long)0L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry length", (long)4L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry value", (long)1L, (long)out.readUnsignedInt());
        out.skipBytes(4);
        Assert.assertEquals((String)"Wrong action type", (long)26L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action length", (long)8L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action ethertype", (long)19L, (long)out.readUnsignedShort());
        out.skipBytes(2);
        Assert.assertEquals((String)"Wrong action type", (long)27L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action length", (long)8L, (long)out.readUnsignedShort());
        out.skipBytes(4);
        Assert.assertTrue((String)"Unread data", (out.readableBytes() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testHeaders() {
        ArrayList<Action> actions = new ArrayList<Action>();
        ActionBuilder actionBuilder = new ActionBuilder();
        OutputActionCaseBuilder caseBuilder = new OutputActionCaseBuilder();
        OutputActionBuilder outputBuilder = new OutputActionBuilder();
        outputBuilder.setPort(new PortNumber(Long.valueOf(42L)));
        outputBuilder.setMaxLength(Integer.valueOf(52));
        caseBuilder.setOutputAction(outputBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)caseBuilder.build());
        actions.add(actionBuilder.build());
        actionBuilder = new ActionBuilder();
        SetFieldCaseBuilder setFieldCaseBuilder = new SetFieldCaseBuilder();
        SetFieldActionBuilder setFieldBuilder = new SetFieldActionBuilder();
        ArrayList<MatchEntry> entries = new ArrayList<MatchEntry>();
        MatchEntryBuilder matchBuilder = new MatchEntryBuilder();
        matchBuilder.setOxmClass(OpenflowBasicClass.class);
        matchBuilder.setOxmMatchField(InPort.class);
        matchBuilder.setHasMask(Boolean.valueOf(false));
        InPortCaseBuilder inPortCaseBuilder = new InPortCaseBuilder();
        InPortBuilder inPortBuilder = new InPortBuilder();
        inPortBuilder.setPortNumber(new PortNumber(Long.valueOf(1L)));
        inPortCaseBuilder.setInPort(inPortBuilder.build());
        matchBuilder.setMatchEntryValue((MatchEntryValue)inPortCaseBuilder.build());
        entries.add(matchBuilder.build());
        setFieldBuilder.setMatchEntry(entries);
        setFieldCaseBuilder.setSetFieldAction(setFieldBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)setFieldCaseBuilder.build());
        actions.add(actionBuilder.build());
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        ListSerializer.serializeHeaderList(actions, (TypeKeyMaker)TypeKeyMakerFactory.createActionKeyMaker((short)4), (SerializerRegistry)this.registry, (ByteBuf)out);
        Assert.assertEquals((String)"Wrong action type", (long)0L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action length", (long)4L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action type", (long)25L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action length", (long)4L, (long)out.readUnsignedShort());
        Assert.assertTrue((String)"Unread data", (out.readableBytes() == 0 ? 1 : 0) != 0);
    }
}

