/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.ListSerializer;
import org.opendaylight.openflowjava.protocol.impl.util.TypeKeyMaker;
import org.opendaylight.openflowjava.protocol.impl.util.TypeKeyMakerFactory;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.ActionChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.OutputActionCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.PopPbbCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.PushVlanCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.SetNwTtlCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.output.action._case.OutputActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.push.vlan._case.PushVlanActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.set.nw.ttl._case.SetNwTtlActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.ActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.InstructionChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.ApplyActionsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.ClearActionsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.GotoTableCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.MeterCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.WriteActionsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.WriteMetadataCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice._goto.table._case.GotoTableBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.apply.actions._case.ApplyActionsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.meter._case.MeterBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.write.actions._case.WriteActionsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.write.metadata._case.WriteMetadataBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instructions.grouping.Instruction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instructions.grouping.InstructionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.EtherType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber;

public class OF13InstructionsSerializerTest {
    private SerializerRegistry registry;

    @Before
    public void startUp() {
        this.registry = new SerializerRegistryImpl();
        this.registry.init();
    }

    @Test
    public void test() {
        ArrayList<Instruction> instructions = new ArrayList<Instruction>();
        InstructionBuilder builder = new InstructionBuilder();
        GotoTableCaseBuilder gotoCaseBuilder = new GotoTableCaseBuilder();
        GotoTableBuilder instructionBuilder = new GotoTableBuilder();
        instructionBuilder.setTableId(Short.valueOf((short)5));
        gotoCaseBuilder.setGotoTable(instructionBuilder.build());
        builder.setInstructionChoice((InstructionChoice)gotoCaseBuilder.build());
        instructions.add(builder.build());
        builder = new InstructionBuilder();
        WriteMetadataCaseBuilder metadataCaseBuilder = new WriteMetadataCaseBuilder();
        WriteMetadataBuilder metadataBuilder = new WriteMetadataBuilder();
        metadataBuilder.setMetadata(ByteBufUtils.hexStringToBytes((String)"00 01 02 03 04 05 06 07"));
        metadataBuilder.setMetadataMask(ByteBufUtils.hexStringToBytes((String)"07 06 05 04 03 02 01 00"));
        metadataCaseBuilder.setWriteMetadata(metadataBuilder.build());
        builder.setInstructionChoice((InstructionChoice)metadataCaseBuilder.build());
        instructions.add(builder.build());
        builder = new InstructionBuilder();
        builder.setInstructionChoice((InstructionChoice)new ClearActionsCaseBuilder().build());
        instructions.add(builder.build());
        builder = new InstructionBuilder();
        MeterCaseBuilder meterCaseBuilder = new MeterCaseBuilder();
        MeterBuilder meterBuilder = new MeterBuilder();
        meterBuilder.setMeterId(Long.valueOf(42L));
        meterCaseBuilder.setMeter(meterBuilder.build());
        builder.setInstructionChoice((InstructionChoice)meterCaseBuilder.build());
        instructions.add(builder.build());
        builder = new InstructionBuilder();
        WriteActionsCaseBuilder writeActionsCaseBuilder = new WriteActionsCaseBuilder();
        WriteActionsBuilder writeActionsBuilder = new WriteActionsBuilder();
        ArrayList<Action> actions = new ArrayList<Action>();
        ActionBuilder actionBuilder = new ActionBuilder();
        OutputActionCaseBuilder caseBuilder = new OutputActionCaseBuilder();
        OutputActionBuilder outputBuilder = new OutputActionBuilder();
        outputBuilder.setPort(new PortNumber(Long.valueOf(45L)));
        outputBuilder.setMaxLength(Integer.valueOf(55));
        caseBuilder.setOutputAction(outputBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)caseBuilder.build());
        actions.add(actionBuilder.build());
        actionBuilder = new ActionBuilder();
        SetNwTtlCaseBuilder ttlCaseBuilder = new SetNwTtlCaseBuilder();
        SetNwTtlActionBuilder ttlActionBuilder = new SetNwTtlActionBuilder();
        ttlActionBuilder.setNwTtl(Short.valueOf((short)64));
        ttlCaseBuilder.setSetNwTtlAction(ttlActionBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)ttlCaseBuilder.build());
        actions.add(actionBuilder.build());
        writeActionsBuilder.setAction(actions);
        writeActionsCaseBuilder.setWriteActions(writeActionsBuilder.build());
        builder.setInstructionChoice((InstructionChoice)writeActionsCaseBuilder.build());
        instructions.add(builder.build());
        builder = new InstructionBuilder();
        ApplyActionsCaseBuilder applyActionsCaseBuilder = new ApplyActionsCaseBuilder();
        ApplyActionsBuilder applyActionsBuilder = new ApplyActionsBuilder();
        actions = new ArrayList();
        actionBuilder = new ActionBuilder();
        PushVlanCaseBuilder vlanCaseBuilder = new PushVlanCaseBuilder();
        PushVlanActionBuilder vlanBuilder = new PushVlanActionBuilder();
        vlanBuilder.setEthertype(new EtherType(new EtherType(Integer.valueOf(14))));
        vlanCaseBuilder.setPushVlanAction(vlanBuilder.build());
        actionBuilder.setActionChoice((ActionChoice)vlanCaseBuilder.build());
        actions.add(actionBuilder.build());
        actionBuilder = new ActionBuilder();
        actionBuilder.setActionChoice((ActionChoice)new PopPbbCaseBuilder().build());
        actions.add(actionBuilder.build());
        applyActionsBuilder.setAction(actions);
        applyActionsCaseBuilder.setApplyActions(applyActionsBuilder.build());
        builder.setInstructionChoice((InstructionChoice)applyActionsCaseBuilder.build());
        instructions.add(builder.build());
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        ListSerializer.serializeList(instructions, (TypeKeyMaker)TypeKeyMakerFactory.createInstructionKeyMaker((short)4), (SerializerRegistry)this.registry, (ByteBuf)out);
        Assert.assertEquals((String)"Wrong instruction type", (long)1L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong instruction length", (long)8L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong instruction table-id", (long)5L, (long)out.readUnsignedByte());
        out.skipBytes(3);
        Assert.assertEquals((String)"Wrong instruction type", (long)2L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong instruction length", (long)24L, (long)out.readUnsignedShort());
        out.skipBytes(4);
        byte[] actual = new byte[8];
        out.readBytes(actual);
        Assert.assertEquals((String)"Wrong instruction metadata", (Object)"00 01 02 03 04 05 06 07", (Object)ByteBufUtils.bytesToHexString((byte[])actual));
        actual = new byte[8];
        out.readBytes(actual);
        Assert.assertEquals((String)"Wrong instruction metadata-mask", (Object)"07 06 05 04 03 02 01 00", (Object)ByteBufUtils.bytesToHexString((byte[])actual));
        Assert.assertEquals((String)"Wrong instruction type", (long)5L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong instruction length", (long)8L, (long)out.readUnsignedShort());
        out.skipBytes(4);
        Assert.assertEquals((String)"Wrong instruction type", (long)6L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong instruction length", (long)8L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong instruction meter-id", (long)42L, (long)out.readUnsignedInt());
        Assert.assertEquals((String)"Wrong instruction type", (long)3L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong instruction length", (long)32L, (long)out.readUnsignedShort());
        out.skipBytes(4);
        Assert.assertEquals((String)"Wrong action type", (long)0L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action length", (long)16L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action type", (long)45L, (long)out.readUnsignedInt());
        Assert.assertEquals((String)"Wrong action type", (long)55L, (long)out.readUnsignedShort());
        out.skipBytes(6);
        Assert.assertEquals((String)"Wrong action type", (long)23L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action length", (long)8L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action type", (long)64L, (long)out.readUnsignedByte());
        out.skipBytes(3);
        Assert.assertEquals((String)"Wrong instruction type", (long)4L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong instruction length", (long)24L, (long)out.readUnsignedShort());
        out.skipBytes(4);
        Assert.assertEquals((String)"Wrong action type", (long)17L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action length", (long)8L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action ethertype", (long)14L, (long)out.readUnsignedShort());
        out.skipBytes(2);
        Assert.assertEquals((String)"Wrong action type", (long)27L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong action length", (long)8L, (long)out.readUnsignedShort());
        out.skipBytes(4);
        Assert.assertTrue((String)"Not all data were read", (out.readableBytes() == 0 ? 1 : 0) != 0);
    }
}

