/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Dscp;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6FlowLabel;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715.MacAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.EtherType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.Ipv6ExthdrFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.ArpOp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.ArpSha;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.ArpSpa;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.ArpTha;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.ArpTpa;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.EthDst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.EthSrc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.EthType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Icmpv4Code;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Icmpv4Type;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Icmpv6Code;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Icmpv6Type;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.InPhyPort;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.InPort;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.IpDscp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.IpEcn;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.IpProto;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Ipv4Dst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Ipv4Src;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Ipv6Dst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Ipv6Exthdr;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Ipv6Flabel;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Ipv6NdSll;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Ipv6NdTarget;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Ipv6NdTll;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Ipv6Src;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Metadata;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MplsBos;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MplsLabel;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MplsTc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OpenflowBasicClass;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OxmMatchType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.PbbIsid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.SctpDst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.SctpSrc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.TcpDst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.TcpSrc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.TunnelId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.UdpDst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.UdpSrc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.VlanPcp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.VlanVid;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.MatchEntryValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ArpOpCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ArpShaCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ArpSpaCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ArpThaCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ArpTpaCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.EthDstCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.EthSrcCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.EthTypeCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.Icmpv4CodeCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.Icmpv4TypeCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.Icmpv6CodeCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.Icmpv6TypeCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.InPhyPortCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.InPortCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.IpDscpCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.IpEcnCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.IpProtoCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.Ipv4DstCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.Ipv4SrcCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.Ipv6DstCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.Ipv6ExthdrCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.Ipv6FlabelCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.Ipv6NdSllCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.Ipv6NdTargetCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.Ipv6NdTllCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.Ipv6SrcCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.MetadataCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.MplsBosCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.MplsLabelCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.MplsTcCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.PbbIsidCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.SctpDstCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.SctpSrcCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.TcpDstCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.TcpSrcCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.TunnelIdCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.UdpDstCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.UdpSrcCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.VlanPcpCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.VlanVidCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.arp.op._case.ArpOpBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.arp.sha._case.ArpShaBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.arp.spa._case.ArpSpaBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.arp.tha._case.ArpThaBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.arp.tpa._case.ArpTpaBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.eth.dst._case.EthDstBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.eth.src._case.EthSrcBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.eth.type._case.EthTypeBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.icmpv4.code._case.Icmpv4CodeBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.icmpv4.type._case.Icmpv4TypeBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.icmpv6.code._case.Icmpv6CodeBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.icmpv6.type._case.Icmpv6TypeBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.in.phy.port._case.InPhyPortBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.in.port._case.InPortBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ip.dscp._case.IpDscpBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ip.ecn._case.IpEcnBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ip.proto._case.IpProtoBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ipv4.dst._case.Ipv4DstBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ipv4.src._case.Ipv4SrcBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ipv6.dst._case.Ipv6DstBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ipv6.exthdr._case.Ipv6ExthdrBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ipv6.flabel._case.Ipv6FlabelBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ipv6.nd.sll._case.Ipv6NdSllBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ipv6.nd.target._case.Ipv6NdTargetBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ipv6.nd.tll._case.Ipv6NdTllBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ipv6.src._case.Ipv6SrcBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.metadata._case.MetadataBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.mpls.bos._case.MplsBosBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.mpls.label._case.MplsLabelBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.mpls.tc._case.MplsTcBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.pbb.isid._case.PbbIsidBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.sctp.dst._case.SctpDstBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.sctp.src._case.SctpSrcBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.tcp.dst._case.TcpDstBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.tcp.src._case.TcpSrcBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.tunnel.id._case.TunnelIdBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.udp.dst._case.UdpDstBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.udp.src._case.UdpSrcBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.vlan.pcp._case.VlanPcpBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.vlan.vid._case.VlanVidBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.grouping.Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.grouping.MatchBuilder;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class OF13MatchSerializer02Test {
    private SerializerRegistry registry;
    private OFSerializer<Match> matchSerializer;

    @Before
    public void startUp() {
        this.registry = new SerializerRegistryImpl();
        this.registry.init();
        this.matchSerializer = (OFSerializer)this.registry.getSerializer(new MessageTypeKey(4, Match.class));
    }

    @Test
    public void testEmptyMatch() {
        MatchBuilder builder = new MatchBuilder();
        builder.setType(OxmMatchType.class);
        Match match = builder.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.matchSerializer.serialize((DataContainer)match, out);
        Assert.assertEquals((String)"Wrong match type", (long)1L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match length", (long)4L, (long)out.readUnsignedShort());
        Assert.assertTrue((String)"Wrong padding", (out.readableBytes() == 4 ? 1 : 0) != 0);
    }

    @Test
    public void test() {
        MatchBuilder builder = new MatchBuilder();
        builder.setType(OxmMatchType.class);
        ArrayList<MatchEntry> entries = new ArrayList<MatchEntry>();
        MatchEntryBuilder entryBuilder = new MatchEntryBuilder();
        entryBuilder.setOxmClass(OpenflowBasicClass.class);
        entryBuilder.setOxmMatchField(InPort.class);
        entryBuilder.setHasMask(Boolean.valueOf(false));
        InPortCaseBuilder inPortCaseBuilder = new InPortCaseBuilder();
        InPortBuilder inPortBuilder = new InPortBuilder();
        inPortBuilder.setPortNumber(new org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber(Long.valueOf(42L)));
        inPortCaseBuilder.setInPort(inPortBuilder.build());
        entryBuilder.setMatchEntryValue((MatchEntryValue)inPortCaseBuilder.build());
        entries.add(entryBuilder.build());
        entryBuilder = new MatchEntryBuilder();
        entryBuilder.setOxmClass(OpenflowBasicClass.class);
        entryBuilder.setOxmMatchField(InPhyPort.class);
        entryBuilder.setHasMask(Boolean.valueOf(false));
        InPhyPortCaseBuilder inPhyPortCaseBuilder = new InPhyPortCaseBuilder();
        InPhyPortBuilder inPhyPortBuilder = new InPhyPortBuilder();
        inPhyPortBuilder.setPortNumber(new org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.PortNumber(Long.valueOf(43L)));
        inPhyPortCaseBuilder.setInPhyPort(inPhyPortBuilder.build());
        entryBuilder.setMatchEntryValue((MatchEntryValue)inPhyPortCaseBuilder.build());
        entries.add(entryBuilder.build());
        entryBuilder = new MatchEntryBuilder();
        entryBuilder.setOxmClass(OpenflowBasicClass.class);
        entryBuilder.setOxmMatchField(Metadata.class);
        entryBuilder.setHasMask(Boolean.valueOf(true));
        MetadataCaseBuilder metaCaseBuilder = new MetadataCaseBuilder();
        MetadataBuilder metadataBuilder = new MetadataBuilder();
        metadataBuilder.setMetadata(new byte[]{0, 0, 0, 0, 0, 0, 0, 1});
        metadataBuilder.setMask(new byte[]{0, 0, 0, 0, 0, 0, 0, 2});
        metaCaseBuilder.setMetadata(metadataBuilder.build());
        entryBuilder.setMatchEntryValue((MatchEntryValue)metaCaseBuilder.build());
        entries.add(entryBuilder.build());
        entryBuilder = new MatchEntryBuilder();
        entryBuilder.setOxmClass(OpenflowBasicClass.class);
        entryBuilder.setOxmMatchField(EthDst.class);
        entryBuilder.setHasMask(Boolean.valueOf(true));
        EthDstCaseBuilder ethDstCaseBuilder = new EthDstCaseBuilder();
        EthDstBuilder ethDstBuilder = new EthDstBuilder();
        ethDstBuilder.setMacAddress(new MacAddress("01:00:03:00:00:06"));
        ethDstBuilder.setMask(new byte[]{0, 0, 0, 0, 0, 5});
        ethDstCaseBuilder.setEthDst(ethDstBuilder.build());
        entryBuilder.setMatchEntryValue((MatchEntryValue)ethDstCaseBuilder.build());
        entries.add(entryBuilder.build());
        entryBuilder = new MatchEntryBuilder();
        entryBuilder.setOxmClass(OpenflowBasicClass.class);
        entryBuilder.setOxmMatchField(EthSrc.class);
        entryBuilder.setHasMask(Boolean.valueOf(true));
        EthSrcCaseBuilder ethSrcCaseBuilder = new EthSrcCaseBuilder();
        EthSrcBuilder ethSrcBuilder = new EthSrcBuilder();
        ethSrcBuilder.setMacAddress(new MacAddress("04:00:02:00:00:08"));
        ethSrcBuilder.setMask(new byte[]{0, 0, 0, 0, 0, 2});
        ethSrcCaseBuilder.setEthSrc(ethSrcBuilder.build());
        entryBuilder.setMatchEntryValue((MatchEntryValue)ethSrcCaseBuilder.build());
        entries.add(entryBuilder.build());
        entryBuilder = new MatchEntryBuilder();
        entryBuilder.setOxmClass(OpenflowBasicClass.class);
        entryBuilder.setOxmMatchField(EthType.class);
        entryBuilder.setHasMask(Boolean.valueOf(false));
        EthTypeCaseBuilder ethTypeCaseBuilder = new EthTypeCaseBuilder();
        EthTypeBuilder ethTypeBuilder = new EthTypeBuilder();
        ethTypeBuilder.setEthType(new EtherType(Integer.valueOf(46)));
        ethTypeCaseBuilder.setEthType(ethTypeBuilder.build());
        entryBuilder.setMatchEntryValue((MatchEntryValue)ethTypeCaseBuilder.build());
        entries.add(entryBuilder.build());
        entryBuilder = new MatchEntryBuilder();
        entryBuilder.setOxmClass(OpenflowBasicClass.class);
        entryBuilder.setOxmMatchField(VlanVid.class);
        entryBuilder.setHasMask(Boolean.valueOf(true));
        VlanVidCaseBuilder vlanVidCaseBuilder = new VlanVidCaseBuilder();
        VlanVidBuilder vlanVidBuilder = new VlanVidBuilder();
        vlanVidBuilder.setVlanVid(Integer.valueOf(45));
        vlanVidBuilder.setCfiBit(Boolean.valueOf(true));
        vlanVidBuilder.setMask(new byte[]{0, 9});
        vlanVidCaseBuilder.setVlanVid(vlanVidBuilder.build());
        entryBuilder.setMatchEntryValue((MatchEntryValue)vlanVidCaseBuilder.build());
        entries.add(entryBuilder.build());
        entryBuilder = new MatchEntryBuilder();
        entryBuilder.setOxmClass(OpenflowBasicClass.class);
        entryBuilder.setOxmMatchField(VlanPcp.class);
        entryBuilder.setHasMask(Boolean.valueOf(false));
        VlanPcpCaseBuilder vlanPcpCaseBuilder = new VlanPcpCaseBuilder();
        VlanPcpBuilder vlanPcpBuilder = new VlanPcpBuilder();
        vlanPcpBuilder.setVlanPcp(Short.valueOf((short)14));
        vlanPcpCaseBuilder.setVlanPcp(vlanPcpBuilder.build());
        entryBuilder.setMatchEntryValue((MatchEntryValue)vlanPcpCaseBuilder.build());
        entries.add(entryBuilder.build());
        entryBuilder = new MatchEntryBuilder();
        entryBuilder.setOxmClass(OpenflowBasicClass.class);
        entryBuilder.setOxmMatchField(IpDscp.class);
        entryBuilder.setHasMask(Boolean.valueOf(false));
        IpDscpCaseBuilder ipDscpCaseBuilder = new IpDscpCaseBuilder();
        IpDscpBuilder ipDscpBuilder = new IpDscpBuilder();
        ipDscpBuilder.setDscp(new Dscp(Short.valueOf((short)48)));
        ipDscpCaseBuilder.setIpDscp(ipDscpBuilder.build());
        entryBuilder.setMatchEntryValue((MatchEntryValue)ipDscpCaseBuilder.build());
        entries.add(entryBuilder.build());
        entryBuilder = new MatchEntryBuilder();
        entryBuilder.setOxmClass(OpenflowBasicClass.class);
        entryBuilder.setOxmMatchField(IpEcn.class);
        entryBuilder.setHasMask(Boolean.valueOf(false));
        IpEcnCaseBuilder ipEcnCaseBuilder = new IpEcnCaseBuilder();
        IpEcnBuilder ipEcnBuilder = new IpEcnBuilder();
        ipEcnBuilder.setEcn(Short.valueOf((short)49));
        ipEcnCaseBuilder.setIpEcn(ipEcnBuilder.build());
        entryBuilder.setMatchEntryValue((MatchEntryValue)ipEcnCaseBuilder.build());
        entries.add(entryBuilder.build());
        entryBuilder = new MatchEntryBuilder();
        entryBuilder.setOxmClass(OpenflowBasicClass.class);
        entryBuilder.setOxmMatchField(IpProto.class);
        entryBuilder.setHasMask(Boolean.valueOf(false));
        IpProtoCaseBuilder ipProtoCaseBuilder = new IpProtoCaseBuilder();
        IpProtoBuilder ipProtoBuilder = new IpProtoBuilder();
        ipProtoBuilder.setProtocolNumber(Short.valueOf((short)50));
        ipProtoCaseBuilder.setIpProto(ipProtoBuilder.build());
        entryBuilder.setMatchEntryValue((MatchEntryValue)ipProtoCaseBuilder.build());
        entries.add(entryBuilder.build());
        entryBuilder = new MatchEntryBuilder();
        entryBuilder.setOxmClass(OpenflowBasicClass.class);
        entryBuilder.setOxmMatchField(Ipv4Src.class);
        entryBuilder.setHasMask(Boolean.valueOf(true));
        Ipv4SrcCaseBuilder ipv4SrcCaseBuilder = new Ipv4SrcCaseBuilder();
        Ipv4SrcBuilder ipv4SrcBuilder = new Ipv4SrcBuilder();
        ipv4SrcBuilder.setIpv4Address(new Ipv4Address("10.0.0.1"));
        ipv4SrcBuilder.setMask(new byte[]{0, 0, 0, 14});
        ipv4SrcCaseBuilder.setIpv4Src(ipv4SrcBuilder.build());
        entryBuilder.setMatchEntryValue((MatchEntryValue)ipv4SrcCaseBuilder.build());
        entries.add(entryBuilder.build());
        entryBuilder = new MatchEntryBuilder();
        entryBuilder.setOxmClass(OpenflowBasicClass.class);
        entryBuilder.setOxmMatchField(Ipv4Dst.class);
        entryBuilder.setHasMask(Boolean.valueOf(true));
        Ipv4DstCaseBuilder ipv4DstCaseBuilder = new Ipv4DstCaseBuilder();
        Ipv4DstBuilder ipv4DstBuilder = new Ipv4DstBuilder();
        ipv4DstBuilder.setIpv4Address(new Ipv4Address("10.0.0.2"));
        ipv4DstBuilder.setMask(new byte[]{0, 0, 0, 15});
        ipv4DstCaseBuilder.setIpv4Dst(ipv4DstBuilder.build());
        entryBuilder.setMatchEntryValue((MatchEntryValue)ipv4DstCaseBuilder.build());
        entries.add(entryBuilder.build());
        entryBuilder = new MatchEntryBuilder();
        entryBuilder.setOxmClass(OpenflowBasicClass.class);
        entryBuilder.setOxmMatchField(TcpSrc.class);
        entryBuilder.setHasMask(Boolean.valueOf(false));
        TcpSrcCaseBuilder tcpSrcCaseBuilder = new TcpSrcCaseBuilder();
        TcpSrcBuilder tcpSrcBuilder = new TcpSrcBuilder();
        tcpSrcBuilder.setPort(new PortNumber(Integer.valueOf(6653)));
        tcpSrcCaseBuilder.setTcpSrc(tcpSrcBuilder.build());
        entryBuilder.setMatchEntryValue((MatchEntryValue)tcpSrcCaseBuilder.build());
        entries.add(entryBuilder.build());
        entryBuilder = new MatchEntryBuilder();
        entryBuilder.setOxmClass(OpenflowBasicClass.class);
        entryBuilder.setOxmMatchField(TcpDst.class);
        entryBuilder.setHasMask(Boolean.valueOf(false));
        TcpDstCaseBuilder tcpDstCaseBuilder = new TcpDstCaseBuilder();
        TcpDstBuilder tcpDstBuilder = new TcpDstBuilder();
        tcpDstBuilder.setPort(new PortNumber(Integer.valueOf(6654)));
        tcpDstCaseBuilder.setTcpDst(tcpDstBuilder.build());
        entryBuilder.setMatchEntryValue((MatchEntryValue)tcpDstCaseBuilder.build());
        entries.add(entryBuilder.build());
        entryBuilder = new MatchEntryBuilder();
        entryBuilder.setOxmClass(OpenflowBasicClass.class);
        entryBuilder.setOxmMatchField(UdpSrc.class);
        entryBuilder.setHasMask(Boolean.valueOf(false));
        UdpSrcCaseBuilder udpSrcCaseBuilder = new UdpSrcCaseBuilder();
        UdpSrcBuilder udpSrcBuilder = new UdpSrcBuilder();
        udpSrcBuilder.setPort(new PortNumber(Integer.valueOf(6655)));
        udpSrcCaseBuilder.setUdpSrc(udpSrcBuilder.build());
        entryBuilder.setMatchEntryValue((MatchEntryValue)udpSrcCaseBuilder.build());
        entries.add(entryBuilder.build());
        entryBuilder = new MatchEntryBuilder();
        entryBuilder.setOxmClass(OpenflowBasicClass.class);
        entryBuilder.setOxmMatchField(UdpDst.class);
        entryBuilder.setHasMask(Boolean.valueOf(false));
        UdpDstCaseBuilder udpDstCaseBuilder = new UdpDstCaseBuilder();
        UdpDstBuilder udpDstBuilder = new UdpDstBuilder();
        udpDstBuilder.setPort(new PortNumber(Integer.valueOf(6656)));
        udpDstCaseBuilder.setUdpDst(udpDstBuilder.build());
        entryBuilder.setMatchEntryValue((MatchEntryValue)udpDstCaseBuilder.build());
        entries.add(entryBuilder.build());
        entryBuilder = new MatchEntryBuilder();
        entryBuilder.setOxmClass(OpenflowBasicClass.class);
        entryBuilder.setOxmMatchField(SctpSrc.class);
        entryBuilder.setHasMask(Boolean.valueOf(false));
        SctpSrcCaseBuilder sctpSrcCaseBuilder = new SctpSrcCaseBuilder();
        SctpSrcBuilder sctpSrcBuilder = new SctpSrcBuilder();
        sctpSrcBuilder.setPort(new PortNumber(Integer.valueOf(6657)));
        sctpSrcCaseBuilder.setSctpSrc(sctpSrcBuilder.build());
        entryBuilder.setMatchEntryValue((MatchEntryValue)sctpSrcCaseBuilder.build());
        entries.add(entryBuilder.build());
        entryBuilder = new MatchEntryBuilder();
        entryBuilder.setOxmClass(OpenflowBasicClass.class);
        entryBuilder.setOxmMatchField(SctpDst.class);
        entryBuilder.setHasMask(Boolean.valueOf(false));
        SctpDstCaseBuilder sctpDstCaseBuilder = new SctpDstCaseBuilder();
        SctpDstBuilder sctpDstBuilder = new SctpDstBuilder();
        sctpDstBuilder.setPort(new PortNumber(Integer.valueOf(6658)));
        sctpDstCaseBuilder.setSctpDst(sctpDstBuilder.build());
        entryBuilder.setMatchEntryValue((MatchEntryValue)sctpDstCaseBuilder.build());
        entries.add(entryBuilder.build());
        entryBuilder = new MatchEntryBuilder();
        entryBuilder.setOxmClass(OpenflowBasicClass.class);
        entryBuilder.setOxmMatchField(Icmpv4Type.class);
        entryBuilder.setHasMask(Boolean.valueOf(false));
        Icmpv4TypeCaseBuilder icmpv4TypeCaseBuilder = new Icmpv4TypeCaseBuilder();
        Icmpv4TypeBuilder icmpv4TypeBuilder = new Icmpv4TypeBuilder();
        icmpv4TypeBuilder.setIcmpv4Type(Short.valueOf((short)51));
        icmpv4TypeCaseBuilder.setIcmpv4Type(icmpv4TypeBuilder.build());
        entryBuilder.setMatchEntryValue((MatchEntryValue)icmpv4TypeCaseBuilder.build());
        entries.add(entryBuilder.build());
        entryBuilder = new MatchEntryBuilder();
        entryBuilder.setOxmClass(OpenflowBasicClass.class);
        entryBuilder.setOxmMatchField(Icmpv4Code.class);
        entryBuilder.setHasMask(Boolean.valueOf(false));
        Icmpv4CodeCaseBuilder icmpv4CodeCaseBuilder = new Icmpv4CodeCaseBuilder();
        Icmpv4CodeBuilder icmpv4CodeBuilder = new Icmpv4CodeBuilder();
        icmpv4CodeBuilder.setIcmpv4Code(Short.valueOf((short)52));
        icmpv4CodeCaseBuilder.setIcmpv4Code(icmpv4CodeBuilder.build());
        entryBuilder.setMatchEntryValue((MatchEntryValue)icmpv4CodeCaseBuilder.build());
        entries.add(entryBuilder.build());
        entryBuilder = new MatchEntryBuilder();
        entryBuilder.setOxmClass(OpenflowBasicClass.class);
        entryBuilder.setOxmMatchField(ArpOp.class);
        entryBuilder.setHasMask(Boolean.valueOf(false));
        ArpOpCaseBuilder arpOpCaseBuilder = new ArpOpCaseBuilder();
        ArpOpBuilder arpOpBuilder = new ArpOpBuilder();
        arpOpBuilder.setOpCode(Integer.valueOf(53));
        arpOpCaseBuilder.setArpOp(arpOpBuilder.build());
        entryBuilder.setMatchEntryValue((MatchEntryValue)arpOpCaseBuilder.build());
        entries.add(entryBuilder.build());
        entryBuilder = new MatchEntryBuilder();
        entryBuilder.setOxmClass(OpenflowBasicClass.class);
        entryBuilder.setOxmMatchField(ArpSpa.class);
        entryBuilder.setHasMask(Boolean.valueOf(true));
        ArpSpaCaseBuilder arpSpaCaseBuilder = new ArpSpaCaseBuilder();
        ArpSpaBuilder arpSpaBuilder = new ArpSpaBuilder();
        arpSpaBuilder.setIpv4Address(new Ipv4Address("10.0.0.4"));
        arpSpaBuilder.setMask(new byte[]{0, 0, 0, 16});
        arpSpaCaseBuilder.setArpSpa(arpSpaBuilder.build());
        entryBuilder.setMatchEntryValue((MatchEntryValue)arpSpaCaseBuilder.build());
        entries.add(entryBuilder.build());
        entryBuilder = new MatchEntryBuilder();
        entryBuilder.setOxmClass(OpenflowBasicClass.class);
        entryBuilder.setOxmMatchField(ArpTpa.class);
        entryBuilder.setHasMask(Boolean.valueOf(true));
        ArpTpaCaseBuilder arpTpaCaseBuilder = new ArpTpaCaseBuilder();
        ArpTpaBuilder arpTpaBuilder = new ArpTpaBuilder();
        arpTpaBuilder.setIpv4Address(new Ipv4Address("10.0.0.5"));
        arpTpaBuilder.setMask(new byte[]{0, 0, 0, 17});
        arpTpaCaseBuilder.setArpTpa(arpTpaBuilder.build());
        entryBuilder.setMatchEntryValue((MatchEntryValue)arpTpaCaseBuilder.build());
        entries.add(entryBuilder.build());
        entryBuilder = new MatchEntryBuilder();
        entryBuilder.setOxmClass(OpenflowBasicClass.class);
        entryBuilder.setOxmMatchField(ArpSha.class);
        entryBuilder.setHasMask(Boolean.valueOf(true));
        ArpShaCaseBuilder arpShaCaseBuilder = new ArpShaCaseBuilder();
        ArpShaBuilder arpShaBuilder = new ArpShaBuilder();
        arpShaBuilder.setMacAddress(new MacAddress("00:01:02:03:04:05"));
        arpShaBuilder.setMask(new byte[]{0, 0, 4, 0, 0, 6});
        arpShaCaseBuilder.setArpSha(arpShaBuilder.build());
        entryBuilder.setMatchEntryValue((MatchEntryValue)arpShaCaseBuilder.build());
        entries.add(entryBuilder.build());
        entryBuilder = new MatchEntryBuilder();
        entryBuilder.setOxmClass(OpenflowBasicClass.class);
        entryBuilder.setOxmMatchField(ArpTha.class);
        entryBuilder.setHasMask(Boolean.valueOf(true));
        ArpThaCaseBuilder arpThaCaseBuilder = new ArpThaCaseBuilder();
        ArpThaBuilder arpThaBuilder = new ArpThaBuilder();
        arpThaBuilder.setMacAddress(new MacAddress("00:00:00:00:00:03"));
        arpThaBuilder.setMask(new byte[]{0, 0, 6, 0, 0, 4});
        arpThaCaseBuilder.setArpTha(arpThaBuilder.build());
        entryBuilder.setMatchEntryValue((MatchEntryValue)arpThaCaseBuilder.build());
        entries.add(entryBuilder.build());
        entryBuilder = new MatchEntryBuilder();
        entryBuilder.setOxmClass(OpenflowBasicClass.class);
        entryBuilder.setOxmMatchField(Ipv6Src.class);
        entryBuilder.setHasMask(Boolean.valueOf(true));
        Ipv6SrcCaseBuilder ipv6SrcCaseBuilder = new Ipv6SrcCaseBuilder();
        Ipv6SrcBuilder ipv6SrcBuilder = new Ipv6SrcBuilder();
        ipv6SrcBuilder.setIpv6Address(new Ipv6Address("0:0:0:0:0:0:0:1"));
        ipv6SrcBuilder.setMask(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1});
        ipv6SrcCaseBuilder.setIpv6Src(ipv6SrcBuilder.build());
        entryBuilder.setMatchEntryValue((MatchEntryValue)ipv6SrcCaseBuilder.build());
        entries.add(entryBuilder.build());
        entryBuilder = new MatchEntryBuilder();
        entryBuilder.setOxmClass(OpenflowBasicClass.class);
        entryBuilder.setOxmMatchField(Ipv6Dst.class);
        entryBuilder.setHasMask(Boolean.valueOf(true));
        Ipv6DstCaseBuilder ipv6DstCaseBuilder = new Ipv6DstCaseBuilder();
        Ipv6DstBuilder ipv6DstBuilder = new Ipv6DstBuilder();
        ipv6DstBuilder.setIpv6Address(new Ipv6Address("0:0:1:0:1:0:0:1"));
        ipv6DstBuilder.setMask(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 1});
        ipv6DstCaseBuilder.setIpv6Dst(ipv6DstBuilder.build());
        entryBuilder.setMatchEntryValue((MatchEntryValue)ipv6DstCaseBuilder.build());
        entries.add(entryBuilder.build());
        entryBuilder = new MatchEntryBuilder();
        entryBuilder.setOxmClass(OpenflowBasicClass.class);
        entryBuilder.setOxmMatchField(Ipv6Flabel.class);
        entryBuilder.setHasMask(Boolean.valueOf(false));
        Ipv6FlabelCaseBuilder ipv6FlabelCaseBuilder = new Ipv6FlabelCaseBuilder();
        Ipv6FlabelBuilder ipv6FlabelBuilder = new Ipv6FlabelBuilder();
        ipv6FlabelBuilder.setIpv6Flabel(new Ipv6FlowLabel(Long.valueOf(58L)));
        ipv6FlabelCaseBuilder.setIpv6Flabel(ipv6FlabelBuilder.build());
        entryBuilder.setMatchEntryValue((MatchEntryValue)ipv6FlabelCaseBuilder.build());
        entries.add(entryBuilder.build());
        entryBuilder = new MatchEntryBuilder();
        entryBuilder.setOxmClass(OpenflowBasicClass.class);
        entryBuilder.setOxmMatchField(Icmpv6Type.class);
        entryBuilder.setHasMask(Boolean.valueOf(false));
        Icmpv6TypeCaseBuilder icmpv6TypeCaseBuilder = new Icmpv6TypeCaseBuilder();
        Icmpv6TypeBuilder icmpv6TypeBuilder = new Icmpv6TypeBuilder();
        icmpv6TypeBuilder.setIcmpv6Type(Short.valueOf((short)59));
        icmpv6TypeCaseBuilder.setIcmpv6Type(icmpv6TypeBuilder.build());
        entryBuilder.setMatchEntryValue((MatchEntryValue)icmpv6TypeCaseBuilder.build());
        entries.add(entryBuilder.build());
        entryBuilder = new MatchEntryBuilder();
        entryBuilder.setOxmClass(OpenflowBasicClass.class);
        entryBuilder.setOxmMatchField(Icmpv6Code.class);
        entryBuilder.setHasMask(Boolean.valueOf(false));
        Icmpv6CodeCaseBuilder Icmpv6CodeCaseBuilder2 = new Icmpv6CodeCaseBuilder();
        Icmpv6CodeBuilder Icmpv6CodeBuilder2 = new Icmpv6CodeBuilder();
        Icmpv6CodeBuilder2.setIcmpv6Code(Short.valueOf((short)60));
        Icmpv6CodeCaseBuilder2.setIcmpv6Code(Icmpv6CodeBuilder2.build());
        entryBuilder.setMatchEntryValue((MatchEntryValue)Icmpv6CodeCaseBuilder2.build());
        entries.add(entryBuilder.build());
        entryBuilder.setOxmClass(OpenflowBasicClass.class);
        entryBuilder.setOxmMatchField(Ipv6NdTarget.class);
        entryBuilder.setHasMask(Boolean.valueOf(false));
        Ipv6NdTargetCaseBuilder ipv6NdTargetCaseBuilder = new Ipv6NdTargetCaseBuilder();
        Ipv6NdTargetBuilder ipv6NdTargetBuilder = new Ipv6NdTargetBuilder();
        ipv6NdTargetBuilder.setIpv6Address(new Ipv6Address("F:0:0::0:0:0:1"));
        ipv6NdTargetCaseBuilder.setIpv6NdTarget(ipv6NdTargetBuilder.build());
        entryBuilder.setMatchEntryValue((MatchEntryValue)ipv6NdTargetCaseBuilder.build());
        entries.add(entryBuilder.build());
        entryBuilder = new MatchEntryBuilder();
        entryBuilder.setOxmClass(OpenflowBasicClass.class);
        entryBuilder.setOxmMatchField(Ipv6NdSll.class);
        entryBuilder.setHasMask(Boolean.valueOf(false));
        Ipv6NdSllCaseBuilder ipv6NdSllCaseBuilder = new Ipv6NdSllCaseBuilder();
        Ipv6NdSllBuilder ipv6NdSllBuilder = new Ipv6NdSllBuilder();
        ipv6NdSllBuilder.setMacAddress(new MacAddress("01:00:03:00:00:06"));
        ipv6NdSllCaseBuilder.setIpv6NdSll(ipv6NdSllBuilder.build());
        entryBuilder.setMatchEntryValue((MatchEntryValue)ipv6NdSllCaseBuilder.build());
        entries.add(entryBuilder.build());
        entryBuilder = new MatchEntryBuilder();
        entryBuilder.setOxmClass(OpenflowBasicClass.class);
        entryBuilder.setOxmMatchField(Ipv6NdTll.class);
        entryBuilder.setHasMask(Boolean.valueOf(false));
        Ipv6NdTllCaseBuilder ipv6NdTllCaseBuilder = new Ipv6NdTllCaseBuilder();
        Ipv6NdTllBuilder ipv6NdTllBuilder = new Ipv6NdTllBuilder();
        ipv6NdTllBuilder.setMacAddress(new MacAddress("04:00:02:00:00:08"));
        ipv6NdTllCaseBuilder.setIpv6NdTll(ipv6NdTllBuilder.build());
        entryBuilder.setMatchEntryValue((MatchEntryValue)ipv6NdTllCaseBuilder.build());
        entries.add(entryBuilder.build());
        entryBuilder = new MatchEntryBuilder();
        entryBuilder.setOxmClass(OpenflowBasicClass.class);
        entryBuilder.setOxmMatchField(MplsLabel.class);
        entryBuilder.setHasMask(Boolean.valueOf(false));
        MplsLabelCaseBuilder mplsLabelCaseBuilder = new MplsLabelCaseBuilder();
        MplsLabelBuilder mplsLabelBuilder = new MplsLabelBuilder();
        mplsLabelBuilder.setMplsLabel(Long.valueOf(61L));
        mplsLabelCaseBuilder.setMplsLabel(mplsLabelBuilder.build());
        entryBuilder.setMatchEntryValue((MatchEntryValue)mplsLabelCaseBuilder.build());
        entries.add(entryBuilder.build());
        entryBuilder = new MatchEntryBuilder();
        entryBuilder.setOxmClass(OpenflowBasicClass.class);
        entryBuilder.setOxmMatchField(MplsTc.class);
        entryBuilder.setHasMask(Boolean.valueOf(false));
        MplsTcCaseBuilder MplsTcCaseBuilder2 = new MplsTcCaseBuilder();
        MplsTcBuilder MplsTcBuilder2 = new MplsTcBuilder();
        MplsTcBuilder2.setTc(Short.valueOf((short)62));
        MplsTcCaseBuilder2.setMplsTc(MplsTcBuilder2.build());
        entryBuilder.setMatchEntryValue((MatchEntryValue)MplsTcCaseBuilder2.build());
        entries.add(entryBuilder.build());
        entryBuilder = new MatchEntryBuilder();
        entryBuilder.setOxmClass(OpenflowBasicClass.class);
        entryBuilder.setOxmMatchField(MplsBos.class);
        entryBuilder.setHasMask(Boolean.valueOf(false));
        MplsBosCaseBuilder MplsBosCaseBuilder2 = new MplsBosCaseBuilder();
        MplsBosBuilder MplsBosBuilder2 = new MplsBosBuilder();
        MplsBosBuilder2.setBos(Boolean.valueOf(true));
        MplsBosCaseBuilder2.setMplsBos(MplsBosBuilder2.build());
        entryBuilder.setMatchEntryValue((MatchEntryValue)MplsBosCaseBuilder2.build());
        entries.add(entryBuilder.build());
        entryBuilder = new MatchEntryBuilder();
        entryBuilder.setOxmClass(OpenflowBasicClass.class);
        entryBuilder.setOxmMatchField(PbbIsid.class);
        entryBuilder.setHasMask(Boolean.valueOf(true));
        PbbIsidCaseBuilder pbbIsidCaseBuilder = new PbbIsidCaseBuilder();
        PbbIsidBuilder pbbIsidBuilder = new PbbIsidBuilder();
        pbbIsidBuilder.setIsid(Long.valueOf(64L));
        pbbIsidBuilder.setMask(new byte[]{0, 1, 2});
        pbbIsidCaseBuilder.setPbbIsid(pbbIsidBuilder.build());
        entryBuilder.setMatchEntryValue((MatchEntryValue)pbbIsidCaseBuilder.build());
        entries.add(entryBuilder.build());
        entryBuilder = new MatchEntryBuilder();
        entryBuilder.setOxmClass(OpenflowBasicClass.class);
        entryBuilder.setOxmMatchField(TunnelId.class);
        entryBuilder.setHasMask(Boolean.valueOf(true));
        TunnelIdCaseBuilder tunnelIdCaseBuilder = new TunnelIdCaseBuilder();
        TunnelIdBuilder tunnelIdBuilder = new TunnelIdBuilder();
        tunnelIdBuilder.setTunnelId(new byte[]{0, 0, 0, 0, 0, 0, 0, 1});
        tunnelIdBuilder.setMask(new byte[]{0, 0, 0, 0, 0, 0, 0, 2});
        tunnelIdCaseBuilder.setTunnelId(tunnelIdBuilder.build());
        entryBuilder.setMatchEntryValue((MatchEntryValue)tunnelIdCaseBuilder.build());
        entries.add(entryBuilder.build());
        entryBuilder = new MatchEntryBuilder();
        entryBuilder.setOxmClass(OpenflowBasicClass.class);
        entryBuilder.setOxmMatchField(Ipv6Exthdr.class);
        entryBuilder.setHasMask(Boolean.valueOf(true));
        Ipv6ExthdrCaseBuilder ipv6ExthdrCaseBuilder = new Ipv6ExthdrCaseBuilder();
        Ipv6ExthdrBuilder ipv6ExthdrBuilder = new Ipv6ExthdrBuilder();
        ipv6ExthdrBuilder.setPseudoField(new Ipv6ExthdrFlags(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(true)));
        ipv6ExthdrBuilder.setMask(new byte[]{0, 2});
        ipv6ExthdrCaseBuilder.setIpv6Exthdr(ipv6ExthdrBuilder.build());
        entryBuilder.setMatchEntryValue((MatchEntryValue)ipv6ExthdrCaseBuilder.build());
        entries.add(entryBuilder.build());
        builder.setMatchEntry(entries);
        Match match = builder.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.matchSerializer.serialize((DataContainer)match, out);
        Assert.assertEquals((String)"Wrong match type", (long)1L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match length", (long)424L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry field & hasMask", (long)0L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry length", (long)4L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry value", (long)42L, (long)out.readUnsignedInt());
        Assert.assertEquals((String)"Wrong match entry class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry field & hasMask", (long)2L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry length", (long)4L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry value", (long)43L, (long)out.readUnsignedInt());
        Assert.assertEquals((String)"Wrong match entry class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry field & hasMask", (long)5L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry length", (long)16L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry value", (long)1L, (long)out.readLong());
        Assert.assertEquals((String)"Wrong match entry mask", (long)2L, (long)out.readLong());
        Assert.assertEquals((String)"Wrong match entry class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry field & hasMask", (long)7L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry length", (long)12L, (long)out.readUnsignedByte());
        byte[] array = new byte[6];
        out.readBytes(array);
        Assert.assertArrayEquals((String)"Wrong match entry value", (byte[])new byte[]{1, 0, 3, 0, 0, 6}, (byte[])array);
        array = new byte[6];
        out.readBytes(array);
        Assert.assertArrayEquals((String)"Wrong match entry mask", (byte[])new byte[]{0, 0, 0, 0, 0, 5}, (byte[])array);
        Assert.assertEquals((String)"Wrong match entry class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry field & hasMask", (long)9L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry length", (long)12L, (long)out.readUnsignedByte());
        array = new byte[6];
        out.readBytes(array);
        Assert.assertArrayEquals((String)"Wrong match entry value", (byte[])new byte[]{4, 0, 2, 0, 0, 8}, (byte[])array);
        array = new byte[6];
        out.readBytes(array);
        Assert.assertArrayEquals((String)"Wrong match entry mask", (byte[])new byte[]{0, 0, 0, 0, 0, 2}, (byte[])array);
        Assert.assertEquals((String)"Wrong match entry class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry field & hasMask", (long)10L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry length", (long)2L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry value", (long)46L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry field & hasMask", (long)13L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry length", (long)4L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry value", (long)4141L, (long)out.readUnsignedShort());
        array = new byte[2];
        out.readBytes(array);
        Assert.assertArrayEquals((String)"Wrong match entry mask", (byte[])new byte[]{0, 9}, (byte[])array);
        Assert.assertEquals((String)"Wrong match entry class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry field & hasMask", (long)14L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry length", (long)1L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry value", (long)14L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry field & hasMask", (long)16L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry length", (long)1L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry value", (long)48L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry field & hasMask", (long)18L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry length", (long)1L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry value", (long)49L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry field & hasMask", (long)20L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry length", (long)1L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry value", (long)50L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry field & hasMask", (long)23L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry length", (long)8L, (long)out.readUnsignedByte());
        array = new byte[4];
        out.readBytes(array);
        Assert.assertArrayEquals((String)"Wrong match entry value", (byte[])new byte[]{10, 0, 0, 1}, (byte[])array);
        array = new byte[4];
        out.readBytes(array);
        Assert.assertArrayEquals((String)"Wrong match entry mask", (byte[])new byte[]{0, 0, 0, 14}, (byte[])array);
        Assert.assertEquals((String)"Wrong match entry class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry field & hasMask", (long)25L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry length", (long)8L, (long)out.readUnsignedByte());
        array = new byte[4];
        out.readBytes(array);
        Assert.assertArrayEquals((String)"Wrong match entry value", (byte[])new byte[]{10, 0, 0, 2}, (byte[])array);
        array = new byte[4];
        out.readBytes(array);
        Assert.assertArrayEquals((String)"Wrong match entry mask", (byte[])new byte[]{0, 0, 0, 15}, (byte[])array);
        Assert.assertEquals((String)"Wrong match entry class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry field & hasMask", (long)26L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry length", (long)2L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry value", (long)6653L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry field & hasMask", (long)28L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry length", (long)2L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry value", (long)6654L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry field & hasMask", (long)30L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry length", (long)2L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry value", (long)6655L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry field & hasMask", (long)32L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry length", (long)2L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry value", (long)6656L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry field & hasMask", (long)34L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry length", (long)2L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry value", (long)6657L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry field & hasMask", (long)36L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry length", (long)2L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry value", (long)6658L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry field & hasMask", (long)38L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry length", (long)1L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry value", (long)51L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry field & hasMask", (long)40L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry length", (long)1L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry value", (long)52L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry field & hasMask", (long)42L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry length", (long)2L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry value", (long)53L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry field & hasMask", (long)45L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry length", (long)8L, (long)out.readUnsignedByte());
        array = new byte[4];
        out.readBytes(array);
        Assert.assertArrayEquals((String)"Wrong match entry value", (byte[])new byte[]{10, 0, 0, 4}, (byte[])array);
        array = new byte[4];
        out.readBytes(array);
        Assert.assertArrayEquals((String)"Wrong match entry mask", (byte[])new byte[]{0, 0, 0, 16}, (byte[])array);
        Assert.assertEquals((String)"Wrong match entry class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry field & hasMask", (long)47L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry length", (long)8L, (long)out.readUnsignedByte());
        array = new byte[4];
        out.readBytes(array);
        Assert.assertArrayEquals((String)"Wrong match entry value", (byte[])new byte[]{10, 0, 0, 5}, (byte[])array);
        array = new byte[4];
        out.readBytes(array);
        Assert.assertArrayEquals((String)"Wrong match entry mask", (byte[])new byte[]{0, 0, 0, 17}, (byte[])array);
        Assert.assertEquals((String)"Wrong match entry class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry field & hasMask", (long)49L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry length", (long)12L, (long)out.readUnsignedByte());
        array = new byte[6];
        out.readBytes(array);
        Assert.assertArrayEquals((String)"Wrong match entry value", (byte[])new byte[]{0, 1, 2, 3, 4, 5}, (byte[])array);
        array = new byte[6];
        out.readBytes(array);
        Assert.assertArrayEquals((String)"Wrong match entry mask", (byte[])new byte[]{0, 0, 4, 0, 0, 6}, (byte[])array);
        Assert.assertEquals((String)"Wrong match entry class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry field & hasMask", (long)51L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry length", (long)12L, (long)out.readUnsignedByte());
        array = new byte[6];
        out.readBytes(array);
        Assert.assertArrayEquals((String)"Wrong match entry value", (byte[])new byte[]{0, 0, 0, 0, 0, 3}, (byte[])array);
        array = new byte[6];
        out.readBytes(array);
        Assert.assertArrayEquals((String)"Wrong match entry mask", (byte[])new byte[]{0, 0, 6, 0, 0, 4}, (byte[])array);
        Assert.assertEquals((String)"Wrong match entry class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry field & hasMask", (long)53L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry length", (long)32L, (long)out.readUnsignedByte());
        array = new byte[16];
        out.readBytes(array);
        Assert.assertArrayEquals((String)"Wrong match entry value", (byte[])new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1}, (byte[])array);
        array = new byte[16];
        out.readBytes(array);
        Assert.assertArrayEquals((String)"Wrong match entry mask", (byte[])new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1}, (byte[])array);
        Assert.assertEquals((String)"Wrong match entry class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry field & hasMask", (long)55L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry length", (long)32L, (long)out.readUnsignedByte());
        array = new byte[16];
        out.readBytes(array);
        Assert.assertArrayEquals((String)"Wrong match entry value", (byte[])new byte[]{0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1}, (byte[])array);
        array = new byte[16];
        out.readBytes(array);
        Assert.assertArrayEquals((String)"Wrong match entry mask", (byte[])new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 1}, (byte[])array);
        Assert.assertEquals((String)"Wrong match entry class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry field & hasMask", (long)56L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry length", (long)4L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry value", (long)58L, (long)out.readUnsignedInt());
        Assert.assertEquals((String)"Wrong match entry class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry field & hasMask", (long)58L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry length", (long)1L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry value", (long)59L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry field & hasMask", (long)60L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry length", (long)1L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry value", (long)60L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry field & hasMask", (long)62L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry length", (long)16L, (long)out.readUnsignedByte());
        array = new byte[16];
        out.readBytes(array);
        Assert.assertArrayEquals((String)"Wrong match entry value", (byte[])new byte[]{0, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1}, (byte[])array);
        Assert.assertEquals((String)"Wrong match entry class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry field & hasMask", (long)64L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry length", (long)6L, (long)out.readUnsignedByte());
        array = new byte[6];
        out.readBytes(array);
        Assert.assertArrayEquals((String)"Wrong match entry value", (byte[])new byte[]{1, 0, 3, 0, 0, 6}, (byte[])array);
        Assert.assertEquals((String)"Wrong match entry class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry field & hasMask", (long)66L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry length", (long)6L, (long)out.readUnsignedByte());
        array = new byte[6];
        out.readBytes(array);
        Assert.assertArrayEquals((String)"Wrong match entry value", (byte[])new byte[]{4, 0, 2, 0, 0, 8}, (byte[])array);
        Assert.assertEquals((String)"Wrong match entry class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry field & hasMask", (long)68L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry length", (long)4L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry value", (long)61L, (long)out.readUnsignedInt());
        Assert.assertEquals((String)"Wrong match entry class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry field & hasMask", (long)70L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry length", (long)1L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry value", (long)62L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry field & hasMask", (long)72L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry length", (long)1L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry value", (long)1L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry field & hasMask", (long)75L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry length", (long)6L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry value", (long)64L, (long)out.readUnsignedMedium());
        array = new byte[3];
        out.readBytes(array);
        Assert.assertArrayEquals((String)"Wrong match entry mask", (byte[])new byte[]{0, 1, 2}, (byte[])array);
        Assert.assertEquals((String)"Wrong match entry class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry field & hasMask", (long)77L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry length", (long)16L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry value", (long)1L, (long)out.readLong());
        Assert.assertEquals((String)"Wrong match entry mask", (long)2L, (long)out.readLong());
        Assert.assertEquals((String)"Wrong match entry class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match entry field & hasMask", (long)79L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry length", (long)4L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong match entry value", (long)358L, (long)out.readUnsignedShort());
        array = new byte[2];
        out.readBytes(array);
        Assert.assertArrayEquals((String)"Wrong match entry value", (byte[])new byte[]{0, 2}, (byte[])array);
        Assert.assertTrue((String)"Wrong padding", (out.readableBytes() == 0 ? 1 : 0) != 0);
    }
}

