/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.extensibility.OFSerializer;
import org.opendaylight.openflowjava.protocol.api.extensibility.SerializerRegistry;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.serialization.SerializerRegistryImpl;
import org.opendaylight.openflowjava.protocol.impl.util.OF13MatchSerializer;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6Address;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6FlowLabel;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.oxm.container.match.entry.value.ExperimenterIdCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.oxm.container.match.entry.value.experimenter.id._case.ExperimenterBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.ExperimenterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.StandardMatchType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.ExperimenterClass;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Ipv4Src;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Ipv6Dst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Ipv6Flabel;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Ipv6NdTarget;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.Ipv6Src;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MatchField;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OpenflowBasicClass;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OxmMatchType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.MatchEntryValue;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.Ipv4SrcCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.Ipv6DstCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.Ipv6FlabelCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.Ipv6NdTargetCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.Ipv6SrcCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ipv4.src._case.Ipv4SrcBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ipv6.dst._case.Ipv6DstBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ipv6.flabel._case.Ipv6FlabelBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ipv6.nd.target._case.Ipv6NdTargetBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.match.entry.value.ipv6.src._case.Ipv6SrcBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.grouping.Match;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.grouping.MatchBuilder;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OF13MatchSerializerTest {
    private static final Logger LOG = LoggerFactory.getLogger(OF13MatchSerializerTest.class);
    private SerializerRegistry registry;
    private OFSerializer<Match> matchSerializer;

    @Before
    public void startUp() {
        this.registry = new SerializerRegistryImpl();
        this.registry.init();
        this.matchSerializer = (OFSerializer)this.registry.getSerializer(new MessageTypeKey(4, Match.class));
    }

    @Test
    public void testIpv4Src() {
        MatchBuilder builder = new MatchBuilder();
        builder.setType(OxmMatchType.class);
        ArrayList<MatchEntry> entries = new ArrayList<MatchEntry>();
        MatchEntryBuilder entriesBuilder = new MatchEntryBuilder();
        entriesBuilder.setOxmClass(OpenflowBasicClass.class);
        entriesBuilder.setOxmMatchField(Ipv4Src.class);
        entriesBuilder.setHasMask(Boolean.valueOf(false));
        Ipv4SrcCaseBuilder ipv4SrcCaseBuilder = new Ipv4SrcCaseBuilder();
        Ipv4SrcBuilder ipv4SrcBuilder = new Ipv4SrcBuilder();
        ipv4SrcBuilder.setIpv4Address(new Ipv4Address("1.2.3.4"));
        ipv4SrcCaseBuilder.setIpv4Src(ipv4SrcBuilder.build());
        entriesBuilder.setMatchEntryValue((MatchEntryValue)ipv4SrcCaseBuilder.build());
        entries.add(entriesBuilder.build());
        builder.setMatchEntry(entries);
        Match match = builder.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.matchSerializer.serialize((DataContainer)match, out);
        Assert.assertEquals((String)"Wrong type", (long)1L, (long)out.readUnsignedShort());
        out.skipBytes(2);
        Assert.assertEquals((String)"Wrong class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong field and mask", (long)22L, (long)out.readUnsignedByte());
        out.skipBytes(1);
        Assert.assertEquals((String)"Wrong ip address (first number)", (long)1L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong ip address (second number)", (long)2L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong ip address (third number)", (long)3L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong ip address (fourth number)", (long)4L, (long)out.readUnsignedByte());
    }

    @Test
    public void testIpv6Various() {
        MatchBuilder builder = new MatchBuilder();
        builder.setType(OxmMatchType.class);
        ArrayList<MatchEntry> entries = new ArrayList<MatchEntry>();
        MatchEntryBuilder entriesBuilder = new MatchEntryBuilder();
        entriesBuilder.setOxmClass(OpenflowBasicClass.class);
        entriesBuilder.setOxmMatchField(Ipv6Src.class);
        entriesBuilder.setHasMask(Boolean.valueOf(false));
        Ipv6SrcCaseBuilder ipv6SrcCaseBuilder = new Ipv6SrcCaseBuilder();
        Ipv6SrcBuilder ipv6SrcBuilder = new Ipv6SrcBuilder();
        ipv6SrcBuilder.setIpv6Address(new Ipv6Address("1:2:3:4:5:6:7:8"));
        ipv6SrcCaseBuilder.setIpv6Src(ipv6SrcBuilder.build());
        entriesBuilder.setMatchEntryValue((MatchEntryValue)ipv6SrcCaseBuilder.build());
        entries.add(entriesBuilder.build());
        entriesBuilder = new MatchEntryBuilder();
        entriesBuilder.setOxmClass(OpenflowBasicClass.class);
        entriesBuilder.setOxmMatchField(Ipv6NdTarget.class);
        entriesBuilder.setHasMask(Boolean.valueOf(false));
        Ipv6NdTargetCaseBuilder ipv6NdTargetCaseBuilder = new Ipv6NdTargetCaseBuilder();
        Ipv6NdTargetBuilder ipv6NdTargetBuilder = new Ipv6NdTargetBuilder();
        ipv6NdTargetBuilder.setIpv6Address(new Ipv6Address("1:2::6:7:8"));
        ipv6NdTargetCaseBuilder.setIpv6NdTarget(ipv6NdTargetBuilder.build());
        entriesBuilder.setMatchEntryValue((MatchEntryValue)ipv6NdTargetCaseBuilder.build());
        entries.add(entriesBuilder.build());
        entriesBuilder = new MatchEntryBuilder();
        entriesBuilder.setOxmClass(OpenflowBasicClass.class);
        entriesBuilder.setOxmMatchField(Ipv6Dst.class);
        entriesBuilder.setHasMask(Boolean.valueOf(false));
        Ipv6DstCaseBuilder ipv6DstCaseBuilder = new Ipv6DstCaseBuilder();
        Ipv6DstBuilder ipv6DstBuilder = new Ipv6DstBuilder();
        ipv6DstBuilder.setIpv6Address(new Ipv6Address("1::8"));
        ipv6DstCaseBuilder.setIpv6Dst(ipv6DstBuilder.build());
        entriesBuilder.setMatchEntryValue((MatchEntryValue)ipv6DstCaseBuilder.build());
        entries.add(entriesBuilder.build());
        entriesBuilder = new MatchEntryBuilder();
        entriesBuilder.setOxmClass(OpenflowBasicClass.class);
        entriesBuilder.setOxmMatchField(Ipv6Dst.class);
        entriesBuilder.setHasMask(Boolean.valueOf(false));
        ipv6DstCaseBuilder = new Ipv6DstCaseBuilder();
        ipv6DstBuilder = new Ipv6DstBuilder();
        ipv6DstBuilder.setIpv6Address(new Ipv6Address("::1"));
        ipv6DstCaseBuilder.setIpv6Dst(ipv6DstBuilder.build());
        entriesBuilder.setMatchEntryValue((MatchEntryValue)ipv6DstCaseBuilder.build());
        entries.add(entriesBuilder.build());
        entriesBuilder = new MatchEntryBuilder();
        entriesBuilder.setOxmClass(OpenflowBasicClass.class);
        entriesBuilder.setOxmMatchField(Ipv6Dst.class);
        entriesBuilder.setHasMask(Boolean.valueOf(false));
        ipv6DstCaseBuilder = new Ipv6DstCaseBuilder();
        ipv6DstBuilder = new Ipv6DstBuilder();
        ipv6DstBuilder.setIpv6Address(new Ipv6Address("::"));
        ipv6DstCaseBuilder.setIpv6Dst(ipv6DstBuilder.build());
        entriesBuilder.setMatchEntryValue((MatchEntryValue)ipv6DstCaseBuilder.build());
        entries.add(entriesBuilder.build());
        builder.setMatchEntry(entries);
        Match match = builder.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.matchSerializer.serialize((DataContainer)match, out);
        Assert.assertEquals((String)"Wrong type", (long)1L, (long)out.readUnsignedShort());
        out.skipBytes(2);
        Assert.assertEquals((String)"Wrong class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong field and mask", (long)52L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong entry length", (long)16L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)1L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)2L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)3L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)4L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)5L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)6L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)7L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)8L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong field and mask", (long)62L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong entry length", (long)16L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)1L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)2L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)0L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)0L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)0L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)6L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)7L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)8L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong field and mask", (long)54L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong entry length", (long)16L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)1L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)0L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)0L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)0L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)0L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)0L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)0L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)8L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong field and mask", (long)54L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong entry length", (long)16L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)0L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)0L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)0L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)0L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)0L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)0L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)0L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)1L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong field and mask", (long)54L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong entry length", (long)16L, (long)out.readUnsignedByte());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)0L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)0L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)0L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)0L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)0L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)0L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)0L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong ipv6 address", (long)0L, (long)out.readUnsignedShort());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIpv6Incorrect() {
        MatchBuilder builder = new MatchBuilder();
        builder.setType(OxmMatchType.class);
        ArrayList<MatchEntry> entries = new ArrayList<MatchEntry>();
        MatchEntryBuilder entriesBuilder = new MatchEntryBuilder();
        entriesBuilder.setOxmClass(OpenflowBasicClass.class);
        entriesBuilder.setOxmMatchField(Ipv6Src.class);
        entriesBuilder.setHasMask(Boolean.valueOf(false));
        Ipv6SrcCaseBuilder ipv6SrcCaseBuilder = new Ipv6SrcCaseBuilder();
        Ipv6SrcBuilder ipv6SrcBuilder = new Ipv6SrcBuilder();
        ipv6SrcBuilder.setIpv6Address(new Ipv6Address("1:2::::8"));
        ipv6SrcCaseBuilder.setIpv6Src(ipv6SrcBuilder.build());
        entriesBuilder.setMatchEntryValue((MatchEntryValue)ipv6SrcCaseBuilder.build());
        entries.add(entriesBuilder.build());
        builder.setMatchEntry(entries);
        Match match = builder.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.matchSerializer.serialize((DataContainer)match, out);
    }

    @Test
    public void testIpv6Flabel() {
        Match match = OF13MatchSerializerTest.buildIpv6FLabelMatch(1023629L, false, null);
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.matchSerializer.serialize((DataContainer)match, out);
        Assert.assertEquals((String)"Wrong type", (long)1L, (long)out.readUnsignedShort());
        out.skipBytes(2);
        Assert.assertEquals((String)"Wrong class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong field and mask", (long)56L, (long)out.readUnsignedByte());
        out.skipBytes(1);
        byte[] label = new byte[4];
        out.readBytes(label);
        LOG.debug("label: {}", (Object)ByteBufUtils.bytesToHexString((byte[])label));
        Assert.assertArrayEquals((String)"Wrong ipv6FLabel", (byte[])new byte[]{0, 15, -98, -115}, (byte[])label);
    }

    @Test
    public void testIpv6FlabelWithMask() {
        Match match = OF13MatchSerializerTest.buildIpv6FLabelMatch(1023629L, true, new byte[]{0, 1, 2, 3});
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.matchSerializer.serialize((DataContainer)match, out);
        Assert.assertEquals((String)"Wrong type", (long)1L, (long)out.readUnsignedShort());
        out.skipBytes(2);
        Assert.assertEquals((String)"Wrong class", (long)32768L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong field and mask", (long)57L, (long)out.readUnsignedByte());
        out.skipBytes(1);
        byte[] label = new byte[4];
        out.readBytes(label);
        Assert.assertArrayEquals((String)"Wrong ipv6FLabel", (byte[])new byte[]{0, 15, -98, -115}, (byte[])label);
        byte[] mask = new byte[4];
        out.readBytes(mask);
        Assert.assertArrayEquals((String)"Wrong ipv6FLabel mask", (byte[])new byte[]{0, 1, 2, 3}, (byte[])mask);
    }

    @Test
    public void testIpv6FlabelWithMaskBad() {
        Match match = OF13MatchSerializerTest.buildIpv6FLabelMatch(1023629L, true, new byte[]{12, 123, 106});
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        try {
            this.matchSerializer.serialize((DataContainer)match, out);
            Assert.fail((String)"incorrect length of mask ignored");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private static Match buildIpv6FLabelMatch(long labelValue, boolean hasMask, byte[] mask) {
        MatchBuilder builder = new MatchBuilder();
        builder.setType(OxmMatchType.class);
        ArrayList<MatchEntry> entries = new ArrayList<MatchEntry>();
        MatchEntryBuilder entriesBuilder = new MatchEntryBuilder();
        entriesBuilder.setOxmClass(OpenflowBasicClass.class);
        entriesBuilder.setOxmMatchField(Ipv6Flabel.class);
        entriesBuilder.setHasMask(Boolean.valueOf(hasMask));
        Ipv6FlabelCaseBuilder ipv6FlabelCaseBuilder = new Ipv6FlabelCaseBuilder();
        Ipv6FlabelBuilder ipv6FlabelBuilder = new Ipv6FlabelBuilder();
        ipv6FlabelBuilder.setIpv6Flabel(new Ipv6FlowLabel(Long.valueOf(labelValue)));
        ipv6FlabelBuilder.setMask(mask);
        ipv6FlabelCaseBuilder.setIpv6Flabel(ipv6FlabelBuilder.build());
        entriesBuilder.setMatchEntryValue((MatchEntryValue)ipv6FlabelCaseBuilder.build());
        entries.add(entriesBuilder.build());
        builder.setMatchEntry(entries);
        Match match = builder.build();
        return match;
    }

    @Test
    public void testStandardMatchType() {
        MatchBuilder builder = new MatchBuilder();
        builder.setType(StandardMatchType.class);
        Match match = builder.build();
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        this.matchSerializer.serialize((DataContainer)match, out);
        Assert.assertEquals((String)"Wrong match type", (long)0L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong match length", (long)4L, (long)out.readUnsignedShort());
        Assert.assertEquals((String)"Wrong padding", (long)0L, (long)out.readUnsignedInt());
        Assert.assertEquals((String)"Unexpected data", (long)0L, (long)out.readableBytes());
    }

    @Test(expected=IllegalStateException.class)
    public void testSerializeExperimenterMatchEntry() {
        ArrayList<MatchEntry> entries = new ArrayList<MatchEntry>();
        MatchEntryBuilder builder = new MatchEntryBuilder();
        builder.setOxmClass(ExperimenterClass.class);
        builder.setOxmMatchField(OxmMatchFieldClass.class);
        builder.setHasMask(Boolean.valueOf(true));
        ExperimenterIdCaseBuilder caseBuilder = new ExperimenterIdCaseBuilder();
        ExperimenterBuilder expBuilder = new ExperimenterBuilder();
        expBuilder.setExperimenter(new ExperimenterId(Long.valueOf(42L)));
        caseBuilder.setExperimenter(expBuilder.build());
        builder.setMatchEntryValue((MatchEntryValue)caseBuilder.build());
        entries.add(builder.build());
        ByteBuf out = UnpooledByteBufAllocator.DEFAULT.buffer();
        ((OF13MatchSerializer)this.matchSerializer).serializeMatchEntries(entries, out);
    }

    private class OxmMatchFieldClass
    extends MatchField {
        private OxmMatchFieldClass() {
        }
    }
}

