/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.util;

import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.openflowjava.protocol.api.keys.ActionSerializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.InstructionSerializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.MatchEntrySerializerKey;
import org.opendaylight.openflowjava.protocol.api.keys.MessageTypeKey;
import org.opendaylight.openflowjava.protocol.impl.util.TypeKeyMaker;
import org.opendaylight.openflowjava.protocol.impl.util.TypeKeyMakerFactory;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.oxm.container.match.entry.value.ExperimenterIdCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.augments.rev150225.oxm.container.match.entry.value.experimenter.id._case.ExperimenterBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.ExperimenterActionSubType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.ActionChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.CopyTtlInCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.CopyTtlInCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.OutputActionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.action.choice.OutputActionCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.ActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.InstructionChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.ClearActionsCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.ClearActionsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.GotoTableCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instruction.grouping.instruction.choice.GotoTableCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instructions.grouping.Instruction;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.instruction.rev130731.instructions.grouping.InstructionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.ExperimenterId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.ExperimenterClass;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.InPort;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.MatchField;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.OpenflowBasicClass;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entries.grouping.MatchEntryBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.oxm.rev150225.match.entry.value.grouping.MatchEntryValue;

public class TypeKeyMakerFactoryTest {
    @Test
    public void testActionKeyMaker() {
        TypeKeyMaker keyMaker = TypeKeyMakerFactory.createActionKeyMaker((short)4);
        Assert.assertNotNull((String)"Null keyMaker", (Object)keyMaker);
        ActionBuilder builder = new ActionBuilder();
        builder.setActionChoice((ActionChoice)new OutputActionCaseBuilder().build());
        Action action = builder.build();
        MessageTypeKey key = keyMaker.make((Object)action);
        Assert.assertNotNull((String)"Null key", (Object)key);
        Assert.assertEquals((String)"Wrong key", (Object)new ActionSerializerKey(4, OutputActionCase.class, null), (Object)key);
    }

    @Test
    public void testExperimenterActionKeyMaker() {
        TypeKeyMaker keyMaker = TypeKeyMakerFactory.createActionKeyMaker((short)4);
        Assert.assertNotNull((String)"Null keyMaker", (Object)keyMaker);
        ActionBuilder builder = new ActionBuilder();
        builder.setExperimenterId(new ExperimenterId(Long.valueOf(42L)));
        builder.setActionChoice((ActionChoice)new CopyTtlInCaseBuilder().build());
        Action action = builder.build();
        MessageTypeKey key = keyMaker.make((Object)action);
        Assert.assertNotNull((String)"Null key", (Object)key);
        Assert.assertEquals((String)"Wrong key", (Object)new ActionSerializerKey(4, CopyTtlInCase.class, Long.valueOf(42L)), (Object)key);
    }

    @Test
    public void testInstructionKeyMaker() {
        TypeKeyMaker keyMaker = TypeKeyMakerFactory.createInstructionKeyMaker((short)4);
        Assert.assertNotNull((String)"Null keyMaker", (Object)keyMaker);
        InstructionBuilder builder = new InstructionBuilder();
        builder.setInstructionChoice((InstructionChoice)new GotoTableCaseBuilder().build());
        Instruction instruction = builder.build();
        MessageTypeKey key = keyMaker.make((Object)instruction);
        Assert.assertNotNull((String)"Null key", (Object)key);
        Assert.assertEquals((String)"Wrong key", (Object)new InstructionSerializerKey(4, GotoTableCase.class, null), (Object)key);
    }

    @Test
    public void testExperimenterInstructionKeyMaker() {
        TypeKeyMaker keyMaker = TypeKeyMakerFactory.createInstructionKeyMaker((short)4);
        Assert.assertNotNull((String)"Null keyMaker", (Object)keyMaker);
        InstructionBuilder builder = new InstructionBuilder();
        builder.setExperimenterId(new ExperimenterId(Long.valueOf(42L)));
        builder.setInstructionChoice((InstructionChoice)new ClearActionsCaseBuilder().build());
        Instruction instruction = builder.build();
        MessageTypeKey key = keyMaker.make((Object)instruction);
        Assert.assertNotNull((String)"Null key", (Object)key);
        Assert.assertEquals((String)"Wrong key", (Object)new InstructionSerializerKey(4, ClearActionsCase.class, Long.valueOf(42L)), (Object)key);
    }

    @Test
    public void testMatchEntriesKeyMaker() {
        TypeKeyMaker keyMaker = TypeKeyMakerFactory.createMatchEntriesKeyMaker((short)4);
        Assert.assertNotNull((String)"Null keyMaker", (Object)keyMaker);
        MatchEntryBuilder builder = new MatchEntryBuilder();
        builder.setOxmClass(OpenflowBasicClass.class);
        builder.setOxmMatchField(InPort.class);
        builder.setHasMask(Boolean.valueOf(true));
        MatchEntry entry = builder.build();
        MessageTypeKey key = keyMaker.make((Object)entry);
        Assert.assertNotNull((String)"Null key", (Object)key);
        MatchEntrySerializerKey comparationKey = new MatchEntrySerializerKey(4, OpenflowBasicClass.class, InPort.class);
        Assert.assertEquals((String)"Wrong key", (Object)comparationKey, (Object)key);
    }

    @Test
    public void testExperimenterMatchEntriesKeyMaker() {
        TypeKeyMaker keyMaker = TypeKeyMakerFactory.createMatchEntriesKeyMaker((short)4);
        Assert.assertNotNull((String)"Null keyMaker", (Object)keyMaker);
        MatchEntryBuilder builder = new MatchEntryBuilder();
        builder.setOxmClass(ExperimenterClass.class);
        builder.setOxmMatchField(OxmMatchFieldClass.class);
        builder.setHasMask(Boolean.valueOf(true));
        ExperimenterIdCaseBuilder caseBuilder = new ExperimenterIdCaseBuilder();
        ExperimenterBuilder expBuilder = new ExperimenterBuilder();
        expBuilder.setExperimenter(new ExperimenterId(Long.valueOf(42L)));
        caseBuilder.setExperimenter(expBuilder.build());
        builder.setMatchEntryValue((MatchEntryValue)caseBuilder.build());
        MatchEntry entry = builder.build();
        MessageTypeKey key = keyMaker.make((Object)entry);
        Assert.assertNotNull((String)"Null key", (Object)key);
        MatchEntrySerializerKey comparationKey = new MatchEntrySerializerKey(4, ExperimenterClass.class, OxmMatchFieldClass.class);
        comparationKey.setExperimenterId(Long.valueOf(42L));
        Assert.assertEquals((String)"Wrong key", (Object)comparationKey, (Object)key);
    }

    private class OxmMatchFieldClass
    extends MatchField {
        private OxmMatchFieldClass() {
        }
    }

    private class ActionSubtypeClass
    extends ExperimenterActionSubType {
        private ActionSubtypeClass() {
        }
    }
}

