/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.statistics;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.openflowjava.statistics.CounterEventTypes;
import org.opendaylight.openflowjava.statistics.StatisticsCounters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsCountersTest {
    private static final Logger LOG = LoggerFactory.getLogger(StatisticsCountersTest.class);
    private StatisticsCounters statCounters;

    @Before
    public void initTest() {
        this.statCounters = StatisticsCounters.getInstance();
        this.statCounters.startCounting(false, 0);
    }

    @After
    public void tierDown() {
        this.statCounters.stopCounting();
    }

    @Test
    public void testCounterAll() {
        int testCount = 4;
        for (CounterEventTypes cet : CounterEventTypes.values()) {
            if (this.statCounters.isCounterEnabled(cet)) {
                this.incrementCounter(cet, testCount);
                Assert.assertEquals((String)("Wrong - bad counter value " + cet), (long)testCount, (long)this.statCounters.getCounter(cet).getCounterValue());
                continue;
            }
            Assert.assertNull((String)"Wrong - not enabled counter give not null value", (Object)this.statCounters.getCounter(cet));
        }
        this.statCounters.resetCounters();
        for (CounterEventTypes cet : CounterEventTypes.values()) {
            if (!this.statCounters.isCounterEnabled(cet)) continue;
            Assert.assertEquals((String)("Wrong - bad counter value after reset " + cet), (long)0L, (long)this.statCounters.getCounter(cet).getCounterValue());
        }
    }

    @Test
    public void testCounterLastRead() {
        int testCount = 4;
        CounterEventTypes firstEnabledCET = null;
        for (CounterEventTypes cet : CounterEventTypes.values()) {
            if (!this.statCounters.isCounterEnabled(cet)) continue;
            firstEnabledCET = cet;
            break;
        }
        if (firstEnabledCET == null) {
            Assert.fail((String)"No counter is enabled");
        }
        this.incrementCounter(firstEnabledCET, testCount);
        LOG.debug("Waiting to process event queue");
        Assert.assertEquals((String)"Wrong - bad last read value.", (long)0L, (long)this.statCounters.getCounter(firstEnabledCET).getCounterLastReadValue());
        Assert.assertEquals((String)"Wrong - bad value", (long)testCount, (long)this.statCounters.getCounter(firstEnabledCET).getCounterValue(false));
        Assert.assertEquals((String)"Wrong - bad last read value.", (long)0L, (long)this.statCounters.getCounter(firstEnabledCET).getCounterLastReadValue());
        Assert.assertEquals((String)"Wrong - bad last read value.", (long)testCount, (long)this.statCounters.getCounter(firstEnabledCET).getCounterValue());
        Assert.assertEquals((String)"Wrong - bad last read value.", (long)testCount, (long)this.statCounters.getCounter(firstEnabledCET).getCounterLastReadValue());
        this.incrementCounter(firstEnabledCET, testCount);
        Assert.assertEquals((String)"Wrong - bad last read value.", (long)testCount, (long)this.statCounters.getCounter(firstEnabledCET).getCounterLastReadValue());
        Assert.assertEquals((String)"Wrong - bad last read value.", (long)(2 * testCount), (long)this.statCounters.getCounter(firstEnabledCET).getCounterValue());
    }

    @Test
    public void testStartStopLogReporter() {
        int testDelay = 10000;
        this.statCounters.startLogReport(testDelay);
        Assert.assertTrue((String)"Wrong - logRepoter is not running", (boolean)this.statCounters.isRunLogReport());
        Assert.assertEquals((String)"Wrong - bad logReportPeriod", (long)testDelay, (long)this.statCounters.getLogReportPeriod());
        this.statCounters.stopLogReport();
        Assert.assertFalse((String)"Wrong - logRepoter is running", (boolean)this.statCounters.isRunLogReport());
        this.statCounters.startLogReport(250);
        Assert.assertTrue((String)"Wrong - logRepoter is not running", (boolean)this.statCounters.isRunLogReport());
        Assert.assertEquals((String)"Wrong - bad logReportPeriod", (long)500L, (long)this.statCounters.getLogReportPeriod());
        this.statCounters.stopCounting();
        Assert.assertFalse((String)"Wrong - logRepoter is running", (boolean)this.statCounters.isRunLogReport());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLogReportBadPeriod() {
        this.statCounters.startLogReport(0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetCounterbyNull() {
        this.statCounters.getCounter(null);
    }

    private void incrementCounter(CounterEventTypes cet, int count) {
        if (!this.statCounters.isCounterEnabled(cet)) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            this.statCounters.incrementCounter(cet);
        }
    }
}

