/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.config.rev160506;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.config.rev140630.TransportProtocol;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.config.rev160506.SwitchConnectionConfig;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.config.rev160506.SwitchConnectionConfigKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.config.rev160506._switch.connection.config.Threads;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.config.rev160506._switch.connection.config.Tls;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SwitchConnectionConfigBuilder
implements Builder<SwitchConnectionConfig> {
    private IpAddress _address;
    private String _instanceName;
    private SwitchConnectionConfigKey _key;
    private Integer _port;
    private Long _switchIdleTimeout;
    private Threads _threads;
    private Tls _tls;
    private TransportProtocol _transportProtocol;
    private Boolean _useBarrier;
    Map<Class<? extends Augmentation<SwitchConnectionConfig>>, Augmentation<SwitchConnectionConfig>> augmentation = Collections.emptyMap();

    public SwitchConnectionConfigBuilder() {
    }

    public SwitchConnectionConfigBuilder(SwitchConnectionConfig base) {
        AugmentationHolder casted;
        if (base.getKey() == null) {
            this._key = new SwitchConnectionConfigKey(base.getInstanceName());
            this._instanceName = base.getInstanceName();
        } else {
            this._key = base.getKey();
            this._instanceName = this._key.getInstanceName();
        }
        this._address = base.getAddress();
        this._port = base.getPort();
        this._switchIdleTimeout = base.getSwitchIdleTimeout();
        this._threads = base.getThreads();
        this._tls = base.getTls();
        this._transportProtocol = base.getTransportProtocol();
        this._useBarrier = base.isUseBarrier();
        if (base instanceof SwitchConnectionConfigImpl) {
            SwitchConnectionConfigImpl impl = (SwitchConnectionConfigImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<SwitchConnectionConfig>>, Augmentation<SwitchConnectionConfig>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SwitchConnectionConfig>>, Augmentation<SwitchConnectionConfig>>(casted.augmentations());
        }
    }

    public IpAddress getAddress() {
        return this._address;
    }

    public String getInstanceName() {
        return this._instanceName;
    }

    public SwitchConnectionConfigKey getKey() {
        return this._key;
    }

    public Integer getPort() {
        return this._port;
    }

    public Long getSwitchIdleTimeout() {
        return this._switchIdleTimeout;
    }

    public Threads getThreads() {
        return this._threads;
    }

    public Tls getTls() {
        return this._tls;
    }

    public TransportProtocol getTransportProtocol() {
        return this._transportProtocol;
    }

    public Boolean isUseBarrier() {
        return this._useBarrier;
    }

    public <E extends Augmentation<SwitchConnectionConfig>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public SwitchConnectionConfigBuilder setAddress(IpAddress value) {
        this._address = value;
        return this;
    }

    public SwitchConnectionConfigBuilder setInstanceName(String value) {
        this._instanceName = value;
        return this;
    }

    public SwitchConnectionConfigBuilder setKey(SwitchConnectionConfigKey value) {
        this._key = value;
        return this;
    }

    private static void checkPortRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public SwitchConnectionConfigBuilder setPort(Integer value) {
        if (value != null) {
            SwitchConnectionConfigBuilder.checkPortRange(value);
        }
        this._port = value;
        return this;
    }

    private static void checkSwitchIdleTimeoutRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public SwitchConnectionConfigBuilder setSwitchIdleTimeout(Long value) {
        if (value != null) {
            SwitchConnectionConfigBuilder.checkSwitchIdleTimeoutRange(value);
        }
        this._switchIdleTimeout = value;
        return this;
    }

    public SwitchConnectionConfigBuilder setThreads(Threads value) {
        this._threads = value;
        return this;
    }

    public SwitchConnectionConfigBuilder setTls(Tls value) {
        this._tls = value;
        return this;
    }

    public SwitchConnectionConfigBuilder setTransportProtocol(TransportProtocol value) {
        this._transportProtocol = value;
        return this;
    }

    public SwitchConnectionConfigBuilder setUseBarrier(Boolean value) {
        this._useBarrier = value;
        return this;
    }

    public SwitchConnectionConfigBuilder addAugmentation(Class<? extends Augmentation<SwitchConnectionConfig>> augmentationType, Augmentation<SwitchConnectionConfig> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SwitchConnectionConfig>>, Augmentation<SwitchConnectionConfig>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public SwitchConnectionConfigBuilder removeAugmentation(Class<? extends Augmentation<SwitchConnectionConfig>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public SwitchConnectionConfig build() {
        return new SwitchConnectionConfigImpl(this);
    }

    private static final class SwitchConnectionConfigImpl
    implements SwitchConnectionConfig {
        private final IpAddress _address;
        private final String _instanceName;
        private final SwitchConnectionConfigKey _key;
        private final Integer _port;
        private final Long _switchIdleTimeout;
        private final Threads _threads;
        private final Tls _tls;
        private final TransportProtocol _transportProtocol;
        private final Boolean _useBarrier;
        private Map<Class<? extends Augmentation<SwitchConnectionConfig>>, Augmentation<SwitchConnectionConfig>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<SwitchConnectionConfig> getImplementedInterface() {
            return SwitchConnectionConfig.class;
        }

        private SwitchConnectionConfigImpl(SwitchConnectionConfigBuilder base) {
            if (base.getKey() == null) {
                this._key = new SwitchConnectionConfigKey(base.getInstanceName());
                this._instanceName = base.getInstanceName();
            } else {
                this._key = base.getKey();
                this._instanceName = this._key.getInstanceName();
            }
            this._address = base.getAddress();
            this._port = base.getPort();
            this._switchIdleTimeout = base.getSwitchIdleTimeout();
            this._threads = base.getThreads();
            this._tls = base.getTls();
            this._transportProtocol = base.getTransportProtocol();
            this._useBarrier = base.isUseBarrier();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<SwitchConnectionConfig>>, Augmentation<SwitchConnectionConfig>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<SwitchConnectionConfig>>, Augmentation<SwitchConnectionConfig>>(base.augmentation);
                }
            }
        }

        @Override
        public IpAddress getAddress() {
            return this._address;
        }

        @Override
        public String getInstanceName() {
            return this._instanceName;
        }

        @Override
        public SwitchConnectionConfigKey getKey() {
            return this._key;
        }

        @Override
        public Integer getPort() {
            return this._port;
        }

        @Override
        public Long getSwitchIdleTimeout() {
            return this._switchIdleTimeout;
        }

        @Override
        public Threads getThreads() {
            return this._threads;
        }

        @Override
        public Tls getTls() {
            return this._tls;
        }

        @Override
        public TransportProtocol getTransportProtocol() {
            return this._transportProtocol;
        }

        @Override
        public Boolean isUseBarrier() {
            return this._useBarrier;
        }

        public <E extends Augmentation<SwitchConnectionConfig>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._address);
            result = 31 * result + Objects.hashCode(this._instanceName);
            result = 31 * result + Objects.hashCode(this._key);
            result = 31 * result + Objects.hashCode(this._port);
            result = 31 * result + Objects.hashCode(this._switchIdleTimeout);
            result = 31 * result + Objects.hashCode(this._threads);
            result = 31 * result + Objects.hashCode(this._tls);
            result = 31 * result + Objects.hashCode(this._transportProtocol);
            result = 31 * result + Objects.hashCode(this._useBarrier);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SwitchConnectionConfig.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SwitchConnectionConfig other = (SwitchConnectionConfig)obj;
            if (!Objects.equals(this._address, other.getAddress())) {
                return false;
            }
            if (!Objects.equals(this._instanceName, other.getInstanceName())) {
                return false;
            }
            if (!Objects.equals(this._key, other.getKey())) {
                return false;
            }
            if (!Objects.equals(this._port, other.getPort())) {
                return false;
            }
            if (!Objects.equals(this._switchIdleTimeout, other.getSwitchIdleTimeout())) {
                return false;
            }
            if (!Objects.equals(this._threads, other.getThreads())) {
                return false;
            }
            if (!Objects.equals(this._tls, other.getTls())) {
                return false;
            }
            if (!Objects.equals(this._transportProtocol, other.getTransportProtocol())) {
                return false;
            }
            if (!Objects.equals(this._useBarrier, other.isUseBarrier())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SwitchConnectionConfigImpl otherImpl = (SwitchConnectionConfigImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<SwitchConnectionConfig>>, Augmentation<SwitchConnectionConfig>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "SwitchConnectionConfig [";
            StringBuilder builder = new StringBuilder(name);
            if (this._address != null) {
                builder.append("_address=");
                builder.append(this._address);
                builder.append(", ");
            }
            if (this._instanceName != null) {
                builder.append("_instanceName=");
                builder.append(this._instanceName);
                builder.append(", ");
            }
            if (this._key != null) {
                builder.append("_key=");
                builder.append(this._key);
                builder.append(", ");
            }
            if (this._port != null) {
                builder.append("_port=");
                builder.append(this._port);
                builder.append(", ");
            }
            if (this._switchIdleTimeout != null) {
                builder.append("_switchIdleTimeout=");
                builder.append(this._switchIdleTimeout);
                builder.append(", ");
            }
            if (this._threads != null) {
                builder.append("_threads=");
                builder.append(this._threads);
                builder.append(", ");
            }
            if (this._tls != null) {
                builder.append("_tls=");
                builder.append(this._tls);
                builder.append(", ");
            }
            if (this._transportProtocol != null) {
                builder.append("_transportProtocol=");
                builder.append(this._transportProtocol);
                builder.append(", ");
            }
            if (this._useBarrier != null) {
                builder.append("_useBarrier=");
                builder.append(this._useBarrier);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

