/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.config.rev160506._switch.connection.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflow._switch.connection.config.rev160506._switch.connection.config.Threads;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ThreadsBuilder
implements Builder<Threads> {
    private Integer _bossThreads;
    private Integer _workerThreads;
    Map<Class<? extends Augmentation<Threads>>, Augmentation<Threads>> augmentation = Collections.emptyMap();

    public ThreadsBuilder() {
    }

    public ThreadsBuilder(Threads base) {
        AugmentationHolder casted;
        this._bossThreads = base.getBossThreads();
        this._workerThreads = base.getWorkerThreads();
        if (base instanceof ThreadsImpl) {
            ThreadsImpl impl = (ThreadsImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Threads>>, Augmentation<Threads>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Threads>>, Augmentation<Threads>>(casted.augmentations());
        }
    }

    public Integer getBossThreads() {
        return this._bossThreads;
    }

    public Integer getWorkerThreads() {
        return this._workerThreads;
    }

    public <E extends Augmentation<Threads>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkBossThreadsRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public ThreadsBuilder setBossThreads(Integer value) {
        if (value != null) {
            ThreadsBuilder.checkBossThreadsRange(value);
        }
        this._bossThreads = value;
        return this;
    }

    private static void checkWorkerThreadsRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public ThreadsBuilder setWorkerThreads(Integer value) {
        if (value != null) {
            ThreadsBuilder.checkWorkerThreadsRange(value);
        }
        this._workerThreads = value;
        return this;
    }

    public ThreadsBuilder addAugmentation(Class<? extends Augmentation<Threads>> augmentationType, Augmentation<Threads> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Threads>>, Augmentation<Threads>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public ThreadsBuilder removeAugmentation(Class<? extends Augmentation<Threads>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Threads build() {
        return new ThreadsImpl(this);
    }

    private static final class ThreadsImpl
    implements Threads {
        private final Integer _bossThreads;
        private final Integer _workerThreads;
        private Map<Class<? extends Augmentation<Threads>>, Augmentation<Threads>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Threads> getImplementedInterface() {
            return Threads.class;
        }

        private ThreadsImpl(ThreadsBuilder base) {
            this._bossThreads = base.getBossThreads();
            this._workerThreads = base.getWorkerThreads();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Threads>>, Augmentation<Threads>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Threads>>, Augmentation<Threads>>(base.augmentation);
                }
            }
        }

        @Override
        public Integer getBossThreads() {
            return this._bossThreads;
        }

        @Override
        public Integer getWorkerThreads() {
            return this._workerThreads;
        }

        public <E extends Augmentation<Threads>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._bossThreads);
            result = 31 * result + Objects.hashCode(this._workerThreads);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Threads.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Threads other = (Threads)obj;
            if (!Objects.equals(this._bossThreads, other.getBossThreads())) {
                return false;
            }
            if (!Objects.equals(this._workerThreads, other.getWorkerThreads())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ThreadsImpl otherImpl = (ThreadsImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Threads>>, Augmentation<Threads>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Threads [";
            StringBuilder builder = new StringBuilder(name);
            if (this._bossThreads != null) {
                builder.append("_bossThreads=");
                builder.append(this._bossThreads);
                builder.append(", ");
            }
            if (this._workerThreads != null) {
                builder.append("_workerThreads=");
                builder.append(this._workerThreads);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

