/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.clients;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.opendaylight.openflowjava.protocol.impl.clients.ClientEvent;
import org.opendaylight.openflowjava.protocol.impl.clients.ScenarioServiceImpl;
import org.opendaylight.openflowjava.protocol.impl.clients.SendEvent;
import org.opendaylight.openflowjava.protocol.impl.clients.WaitForMessageEvent;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.xml.sax.SAXException;

public final class ScenarioFactory {
    private ScenarioFactory() {
        throw new UnsupportedOperationException("Utility class shouldn't be instantiated");
    }

    public static Deque<ClientEvent> createHandshakeScenario() {
        ArrayDeque<ClientEvent> stack = new ArrayDeque<ClientEvent>();
        stack.addFirst(new SendEvent(ByteBufUtils.hexStringToBytes((String)"04 00 00 08 00 00 00 01")));
        stack.addFirst(new WaitForMessageEvent(ByteBufUtils.hexStringToBytes((String)"04 00 00 08 00 00 00 02")));
        stack.addFirst(new WaitForMessageEvent(ByteBufUtils.hexStringToBytes((String)"04 05 00 08 00 00 00 03")));
        stack.addFirst(new SendEvent(ByteBufUtils.hexStringToBytes((String)"04 06 00 20 00 00 00 03 00 01 02 03 04 05 06 07 00 01 02 03 01 00 00 00 00 01 02 03 00 01 02 03")));
        return stack;
    }

    public static Deque<ClientEvent> createHandshakeScenarioWithBarrier() {
        ArrayDeque<ClientEvent> stack = new ArrayDeque<ClientEvent>();
        stack.addFirst(new SendEvent(ByteBufUtils.hexStringToBytes((String)"04 00 00 08 00 00 00 01")));
        stack.addFirst(new WaitForMessageEvent(ByteBufUtils.hexStringToBytes((String)"04 00 00 10 00 00 00 15 00 01 00 08 00 00 00 12")));
        stack.addFirst(new WaitForMessageEvent(ByteBufUtils.hexStringToBytes((String)"04 05 00 08 00 00 00 02")));
        stack.addFirst(new SendEvent(ByteBufUtils.hexStringToBytes((String)"04 06 00 20 00 00 00 02 00 01 02 03 04 05 06 07 00 01 02 03 01 00 00 00 00 01 02 03 00 01 02 03")));
        stack.addFirst(new WaitForMessageEvent(ByteBufUtils.hexStringToBytes((String)"04 14 00 08 00 00 00 00")));
        stack.addFirst(new SendEvent(ByteBufUtils.hexStringToBytes((String)"04 15 00 08 00 00 00 04")));
        return stack;
    }

    public static Deque<ClientEvent> getScenarioFromXml(String scenarioName, String scenarioFile) throws JAXBException, SAXException, IOException {
        ScenarioServiceImpl scenarioService = new ScenarioServiceImpl(scenarioFile);
        ArrayDeque<ClientEvent> stack = new ArrayDeque<ClientEvent>();
        for (Map.Entry<Integer, ClientEvent> clientEvent : scenarioService.getEventsFromScenario(scenarioService.unMarshallData(scenarioName)).entrySet()) {
            stack.addFirst(clientEvent.getValue());
        }
        return stack;
    }

    public static Deque<ClientEvent> createHandshakeScenarioWithAuxiliaryId(byte auxiliaryId) {
        ArrayDeque<ClientEvent> queue = new ArrayDeque<ClientEvent>();
        queue.addFirst(new SendEvent(ByteBufUtils.hexStringToBytes((String)"04 00 00 08 00 00 00 01")));
        queue.addFirst(new WaitForMessageEvent(ByteBufUtils.hexStringToBytes((String)"04 00 00 08 00 00 00 02")));
        queue.addFirst(new WaitForMessageEvent(ByteBufUtils.hexStringToBytes((String)"04 05 00 08 00 00 00 03")));
        queue.addFirst(new SendEvent(ByteBufUtils.hexStringToBytes((String)("04 06 00 20 00 00 00 03 00 01 02 03 04 05 06 07 00 01 02 03 01 " + String.format("%02x ", auxiliaryId) + " 00 00 00 01 02 03 00 01 02 03"))));
        return queue;
    }
}

