/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.clients;

import io.netty.channel.ChannelHandlerContext;
import java.util.Deque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.opendaylight.openflowjava.protocol.impl.clients.ClientEvent;
import org.opendaylight.openflowjava.protocol.impl.clients.SendEvent;
import org.opendaylight.openflowjava.protocol.impl.clients.WaitForMessageEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScenarioHandler
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(ScenarioHandler.class);
    private Deque<ClientEvent> scenario;
    private final BlockingQueue<byte[]> ofMsg;
    private ChannelHandlerContext ctx;
    private int eventNumber;
    private boolean scenarioFinished = false;
    private int freeze = 2;
    private long sleepBetweenTries = 100L;
    private boolean finishedOK = true;

    public ScenarioHandler(Deque<ClientEvent> scenario) {
        this.scenario = scenario;
        this.ofMsg = new LinkedBlockingQueue<byte[]>();
    }

    public ScenarioHandler(Deque<ClientEvent> scenario, int freeze, long sleepBetweenTries) {
        this.scenario = scenario;
        this.ofMsg = new LinkedBlockingQueue<byte[]>();
        this.sleepBetweenTries = sleepBetweenTries;
        this.freeze = freeze;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int freezeCounter = 0;
        while (!this.scenario.isEmpty()) {
            ClientEvent peek;
            block13: {
                ClientEvent event;
                LOG.debug("Running event #{}", (Object)this.eventNumber);
                peek = this.scenario.peekLast();
                if (peek instanceof WaitForMessageEvent) {
                    LOG.debug("WaitForMessageEvent");
                    try {
                        event = (WaitForMessageEvent)peek;
                        ((WaitForMessageEvent)event).setHeaderReceived(this.ofMsg.poll(2000L, TimeUnit.MILLISECONDS));
                        break block13;
                    }
                    catch (InterruptedException e) {
                        LOG.error(e.getMessage(), (Throwable)e);
                        break;
                    }
                }
                if (peek instanceof SendEvent) {
                    LOG.debug("Proceed - sendevent");
                    event = (SendEvent)peek;
                    ((SendEvent)event).setCtx(this.ctx);
                }
            }
            if (peek.eventExecuted()) {
                LOG.info("Scenario step finished OK, moving to next step.");
                this.scenario.removeLast();
                ++this.eventNumber;
                freezeCounter = 0;
                this.finishedOK = true;
            } else {
                LOG.warn("Scenario step not finished NOT OK!", (Object)(++freezeCounter));
            }
            if (freezeCounter > this.freeze) {
                LOG.warn("Scenario frozen: {}", (Object)freezeCounter);
                this.finishedOK = false;
                break;
            }
            try {
                ScenarioHandler.sleep(this.sleepBetweenTries);
            }
            catch (InterruptedException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        LOG.debug("Scenario finished");
        ScenarioHandler scenarioHandler = this;
        synchronized (scenarioHandler) {
            this.scenarioFinished = true;
            this.notify();
        }
    }

    public boolean isEmpty() {
        return this.scenario.isEmpty();
    }

    public Deque<ClientEvent> getScenario() {
        return this.scenario;
    }

    public void setScenario(Deque<ClientEvent> scenario) {
        this.scenario = scenario;
    }

    public void setCtx(ChannelHandlerContext ctx) {
        this.ctx = ctx;
    }

    public void addOfMsg(byte[] message) {
        this.ofMsg.add(message);
    }

    public boolean isScenarioFinished() {
        return this.scenarioFinished;
    }

    public boolean isFinishedOK() {
        return this.finishedOK;
    }
}

