/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.clients;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.opendaylight.openflowjava.protocol.impl.clients.ClientEvent;
import org.opendaylight.openflowjava.protocol.impl.clients.Scenario;
import org.opendaylight.openflowjava.protocol.impl.clients.ScenarioService;
import org.opendaylight.openflowjava.protocol.impl.clients.Scenarios;
import org.opendaylight.openflowjava.protocol.impl.clients.SendEvent;
import org.opendaylight.openflowjava.protocol.impl.clients.SleepEvent;
import org.opendaylight.openflowjava.protocol.impl.clients.Step;
import org.opendaylight.openflowjava.protocol.impl.clients.WaitForMessageEvent;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class ScenarioServiceImpl
implements ScenarioService {
    private static final Logger LOG = LoggerFactory.getLogger(ScenarioServiceImpl.class);
    private String XML_FILE_PATH_WITH_FILE_NAME = "simple-client/src/main/resources/scenario.xml";

    public ScenarioServiceImpl(String scenarioFile) {
        if (null != scenarioFile && !scenarioFile.isEmpty()) {
            this.XML_FILE_PATH_WITH_FILE_NAME = scenarioFile;
        }
    }

    @Override
    public Scenario unMarshallData(String scenarioName) throws SAXException, JAXBException {
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = sf.newSchema(new File("simple-client/src/main/resources/scenario.xsd"));
        LOG.debug("Loading schema from: {}", (Object)"simple-client/src/main/resources/scenario.xsd");
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Scenarios.class});
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        unmarshaller.setSchema(schema);
        Scenarios scenarios = (Scenarios)unmarshaller.unmarshal(new File(this.XML_FILE_PATH_WITH_FILE_NAME));
        LOG.debug("Scenarios ({}) are un-marshaled from {}", (Object)scenarios.getScenario().size(), (Object)this.XML_FILE_PATH_WITH_FILE_NAME);
        boolean foundConfiguration = false;
        Scenario scenarioType = null;
        for (Scenario scenario : scenarios.getScenario()) {
            if (!scenario.getName().equals(scenarioName)) continue;
            scenarioType = scenario;
            foundConfiguration = true;
        }
        if (!foundConfiguration) {
            LOG.warn("Scenario {} not found.", (Object)scenarioName);
        } else {
            LOG.info("Scenario {} found with {} steps.", (Object)scenarioName, (Object)scenarioType.getStep().size());
        }
        return scenarioType;
    }

    @Override
    public SortedMap<Integer, ClientEvent> getEventsFromScenario(Scenario scenario) throws IOException {
        Preconditions.checkNotNull((Object)scenario, (Object)"Scenario name not found. Check XML file, scenario name or directories.");
        TreeMap<Integer, ClientEvent> events = new TreeMap<Integer, ClientEvent>();
        Integer counter = 0;
        for (Step stepType : scenario.getStep()) {
            LOG.debug("Step {}: {}, type {}, bytes {}", new Object[]{stepType.getOrder(), stepType.getName(), stepType.getEvent().value(), stepType.getBytes().toArray()});
            switch (stepType.getEvent()) {
                case SLEEP_EVENT: {
                    Integer n = counter;
                    Integer n2 = counter = Integer.valueOf(counter + 1);
                    events.put(n, new SleepEvent(1000L));
                    break;
                }
                case SEND_EVENT: {
                    Integer n = counter;
                    Integer n2 = counter = Integer.valueOf(counter + 1);
                    events.put(n, new SendEvent(ByteBufUtils.serializableList(stepType.getBytes())));
                    break;
                }
                case WAIT_FOR_MESSAGE_EVENT: {
                    Integer n = counter;
                    Integer n2 = counter = Integer.valueOf(counter + 1);
                    events.put(n, new WaitForMessageEvent(ByteBufUtils.serializableList(stepType.getBytes())));
                }
            }
        }
        return events;
    }
}

