/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.clients;

import com.google.common.util.concurrent.SettableFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.SslHandler;
import javax.net.ssl.SSLEngine;
import org.opendaylight.openflowjava.protocol.impl.clients.ClientSslContextFactory;
import org.opendaylight.openflowjava.protocol.impl.clients.ScenarioHandler;
import org.opendaylight.openflowjava.protocol.impl.clients.SimpleClientFramer;
import org.opendaylight.openflowjava.protocol.impl.clients.SimpleClientHandler;

public class SimpleClientInitializer
extends ChannelInitializer<NioSocketChannel> {
    private SettableFuture<Boolean> isOnlineFuture;
    private final boolean secured;
    private ScenarioHandler scenarioHandler;

    public SimpleClientInitializer(SettableFuture<Boolean> isOnlineFuture, boolean secured) {
        this.isOnlineFuture = isOnlineFuture;
        this.secured = secured;
    }

    public void initChannel(NioSocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        if (this.secured) {
            SSLEngine engine = ClientSslContextFactory.getClientContext().createSSLEngine();
            engine.setUseClientMode(true);
            pipeline.addLast("ssl", (ChannelHandler)new SslHandler(engine));
        }
        SimpleClientHandler simpleClientHandler = new SimpleClientHandler(this.isOnlineFuture, this.scenarioHandler);
        simpleClientHandler.setScenario(this.scenarioHandler);
        pipeline.addLast("framer", (ChannelHandler)new SimpleClientFramer());
        pipeline.addLast("handler", (ChannelHandler)simpleClientHandler);
        this.isOnlineFuture = null;
    }

    public void setScenario(ScenarioHandler scenarioHandler) {
        this.scenarioHandler = scenarioHandler;
    }
}

