/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.clients;

import org.opendaylight.openflowjava.protocol.impl.clients.ClientEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SleepEvent
implements ClientEvent {
    private static final Logger LOG = LoggerFactory.getLogger(SleepEvent.class);
    private final long sleepTime;

    public SleepEvent(long sleepTime) {
        this.sleepTime = sleepTime;
    }

    @Override
    public boolean eventExecuted() {
        try {
            Thread.sleep(this.sleepTime);
            LOG.debug("Sleeping");
            return true;
        }
        catch (InterruptedException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

