/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.clients;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdpSimpleClientFramer
extends MessageToMessageDecoder<DatagramPacket> {
    public static final byte LENGTH_OF_HEADER = 8;
    private static final byte LENGTH_INDEX_IN_HEADER = 2;
    private static final Logger LOG = LoggerFactory.getLogger(UdpSimpleClientFramer.class);

    public UdpSimpleClientFramer() {
        LOG.trace("Creating OFFrameDecoder");
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOG.warn("Unexpected exception from downstream.", cause);
        ctx.close();
    }

    protected void decode(ChannelHandlerContext chc, DatagramPacket msg, List<Object> list) throws Exception {
        ByteBuf bb = (ByteBuf)msg.content();
        if (bb.readableBytes() < 8) {
            LOG.debug("skipping bb - too few data for header: {}", (Object)bb.readableBytes());
            return;
        }
        int length = bb.getUnsignedShort(bb.readerIndex() + 2);
        if (bb.readableBytes() < length) {
            LOG.debug("skipping bb - too few data for msg: {} < {}", (Object)bb.readableBytes(), (Object)length);
            return;
        }
        LOG.debug("OF Protocol message received, type:{}", (Object)bb.getByte(bb.readerIndex() + 1));
        ByteBuf messageBuffer = bb.slice(bb.readerIndex(), length);
        list.add(messageBuffer);
        messageBuffer.retain();
        bb.skipBytes(length);
    }
}

