/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.clients;

import com.google.common.util.concurrent.SettableFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.nio.NioDatagramChannel;
import org.opendaylight.openflowjava.protocol.impl.clients.ScenarioHandler;
import org.opendaylight.openflowjava.protocol.impl.clients.SimpleClientHandler;
import org.opendaylight.openflowjava.protocol.impl.clients.UdpSimpleClientFramer;

public class UdpSimpleClientInitializer
extends ChannelInitializer<NioDatagramChannel> {
    private SettableFuture<Boolean> isOnlineFuture;
    private ScenarioHandler scenarioHandler;

    public UdpSimpleClientInitializer(SettableFuture<Boolean> isOnlineFuture) {
        this.isOnlineFuture = isOnlineFuture;
    }

    public void initChannel(NioDatagramChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        SimpleClientHandler simpleClientHandler = new SimpleClientHandler(this.isOnlineFuture, this.scenarioHandler);
        simpleClientHandler.setScenario(this.scenarioHandler);
        pipeline.addLast("framer", (ChannelHandler)new UdpSimpleClientFramer());
        pipeline.addLast("handler", (ChannelHandler)simpleClientHandler);
        this.isOnlineFuture = null;
    }

    public void setScenario(ScenarioHandler scenarioHandler) {
        this.scenarioHandler = scenarioHandler;
    }
}

