/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.clients;

import java.util.Arrays;
import org.opendaylight.openflowjava.protocol.impl.clients.ClientEvent;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaitForMessageEvent
implements ClientEvent {
    private static final Logger LOG = LoggerFactory.getLogger(WaitForMessageEvent.class);
    private final byte[] headerExpected;
    private byte[] headerReceived;

    public WaitForMessageEvent(byte[] headerExpected) {
        this.headerExpected = new byte[headerExpected.length];
        System.arraycopy(headerExpected, 0, this.headerExpected, 0, headerExpected.length);
    }

    @Override
    public boolean eventExecuted() {
        if (this.headerReceived == null) {
            return false;
        }
        if (!Arrays.equals(this.headerExpected, this.headerReceived)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("expected msg: {}", (Object)ByteBufUtils.bytesToHexString((byte[])this.headerExpected));
                LOG.debug("received msg: {}", (Object)ByteBufUtils.bytesToHexString((byte[])this.headerReceived));
            }
            return false;
        }
        LOG.debug("Headers OK");
        return true;
    }

    public void setHeaderReceived(byte[] headerReceived) {
        if (headerReceived != null) {
            this.headerReceived = new byte[headerReceived.length];
            System.arraycopy(headerReceived, 0, this.headerReceived, 0, headerReceived.length);
        }
    }
}

