/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.clients;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.SettableFuture;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.net.InetAddress;
import java.util.concurrent.Callable;
import org.opendaylight.openflowjava.protocol.impl.clients.OFClient;
import org.opendaylight.openflowjava.protocol.impl.clients.ScenarioHandler;
import org.opendaylight.openflowjava.protocol.impl.clients.SimpleClientInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallableClient
implements Callable<Boolean>,
OFClient {
    private static final Logger LOG = LoggerFactory.getLogger(CallableClient.class);
    private int port = 6653;
    private boolean securedClient = false;
    private InetAddress ipAddress = null;
    private String name = "Empty name";
    private final EventLoopGroup workerGroup;
    private SettableFuture<Boolean> isOnlineFuture;
    private SettableFuture<Boolean> scenarioDone;
    private ScenarioHandler scenarioHandler = null;
    private Bootstrap bootstrap = null;

    public CallableClient(int port, boolean securedClient, InetAddress ipAddress, String name, ScenarioHandler scenarioHandler, Bootstrap bootstrap, EventLoopGroup eventExecutors) {
        Preconditions.checkNotNull((Object)ipAddress, (Object)"IP address cannot be null");
        Preconditions.checkNotNull((Object)scenarioHandler, (Object)"Scenario handler cannot be null");
        this.port = port;
        this.securedClient = securedClient;
        this.ipAddress = ipAddress;
        this.workerGroup = eventExecutors;
        this.bootstrap = bootstrap;
        this.name = name;
        this.scenarioHandler = scenarioHandler;
    }

    @Override
    public SettableFuture<Boolean> getIsOnlineFuture() {
        return this.isOnlineFuture;
    }

    @Override
    public SettableFuture<Boolean> getScenarioDone() {
        return this.scenarioDone;
    }

    @Override
    public void setScenarioHandler(ScenarioHandler scenario) {
        this.scenarioHandler = scenario;
    }

    @Override
    public void setSecuredClient(boolean securedClient) {
        this.securedClient = securedClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean call() throws Exception {
        Preconditions.checkNotNull((Object)this.bootstrap);
        Preconditions.checkNotNull((Object)this.workerGroup);
        LOG.info("Switch {} trying connect to controller", (Object)this.name);
        SimpleClientInitializer clientInitializer = new SimpleClientInitializer(this.isOnlineFuture, this.securedClient);
        clientInitializer.setScenario(this.scenarioHandler);
        try {
            ((Bootstrap)((Bootstrap)this.bootstrap.group(this.workerGroup)).channel(NioSocketChannel.class)).handler((ChannelHandler)clientInitializer);
            this.bootstrap.connect(this.ipAddress, this.port).sync();
            ScenarioHandler scenarioHandler = this.scenarioHandler;
            synchronized (scenarioHandler) {
                LOG.debug("WAITING FOR SCENARIO");
                while (!this.scenarioHandler.isScenarioFinished()) {
                    this.scenarioHandler.wait();
                }
            }
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
            return false;
        }
        if (this.scenarioHandler.isFinishedOK()) {
            LOG.info("Device {} finished scenario OK", (Object)this.name);
        } else {
            LOG.error("Device {} finished scenario with error", (Object)this.name);
        }
        return this.scenarioHandler.isFinishedOK();
    }

    @Override
    public void run() {
        throw new UnsupportedOperationException();
    }
}

