/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.clients;

import com.google.common.util.concurrent.SettableFuture;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.Future;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutionException;
import org.opendaylight.openflowjava.protocol.impl.clients.OFClient;
import org.opendaylight.openflowjava.protocol.impl.clients.ScenarioHandler;
import org.opendaylight.openflowjava.protocol.impl.clients.SimpleClientInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListeningSimpleClient
implements OFClient {
    private static final Logger LOG = LoggerFactory.getLogger(ListeningSimpleClient.class);
    private int port;
    private boolean securedClient = false;
    private EventLoopGroup workerGroup;
    private SettableFuture<Boolean> isOnlineFuture;
    private SettableFuture<Boolean> scenarioDone;
    private ScenarioHandler scenarioHandler;

    public ListeningSimpleClient(int port) {
        this.port = port;
        this.init();
    }

    private void init() {
        this.isOnlineFuture = SettableFuture.create();
        this.scenarioDone = SettableFuture.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
        this.workerGroup = new NioEventLoopGroup();
        SimpleClientInitializer clientInitializer = new SimpleClientInitializer(this.isOnlineFuture, this.securedClient);
        clientInitializer.setScenario(this.scenarioHandler);
        try {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)b.group((EventLoopGroup)bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)clientInitializer);
            ChannelFuture f = b.bind(this.port).sync();
            this.port = ((InetSocketAddress)f.channel().localAddress()).getPort();
            this.isOnlineFuture.set((Object)true);
            ScenarioHandler scenarioHandler = this.scenarioHandler;
            synchronized (scenarioHandler) {
                LOG.debug("WAITING FOR SCENARIO");
                while (!this.scenarioHandler.isScenarioFinished()) {
                    this.scenarioHandler.wait();
                }
            }
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            LOG.debug("listening client shutting down");
            try {
                this.workerGroup.shutdownGracefully().get();
                bossGroup.shutdownGracefully().get();
                LOG.debug("listening client shutdown succesful");
            }
            catch (InterruptedException | ExecutionException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        this.scenarioDone.set((Object)true);
    }

    public Future<?> disconnect() {
        LOG.debug("disconnecting client");
        return this.workerGroup.shutdownGracefully();
    }

    @Override
    public void setSecuredClient(boolean securedClient) {
        this.securedClient = securedClient;
    }

    @Override
    public SettableFuture<Boolean> getIsOnlineFuture() {
        return this.isOnlineFuture;
    }

    @Override
    public SettableFuture<Boolean> getScenarioDone() {
        return this.scenarioDone;
    }

    @Override
    public void setScenarioHandler(ScenarioHandler scenario) {
        this.scenarioHandler = scenario;
    }

    public int getPort() {
        return this.port;
    }
}

