/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.clients;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import org.opendaylight.openflowjava.protocol.impl.clients.ClientEvent;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendEvent
implements ClientEvent {
    private static final Logger LOG = LoggerFactory.getLogger(SendEvent.class);
    protected byte[] msgToSend;
    protected ChannelHandlerContext ctx;

    public SendEvent(byte[] msgToSend) {
        this.msgToSend = new byte[msgToSend.length];
        System.arraycopy(msgToSend, 0, this.msgToSend, 0, msgToSend.length);
    }

    @Override
    public boolean eventExecuted() {
        LOG.debug("sending message");
        LOG.debug("start of run");
        ByteBuf buffer = this.ctx.alloc().buffer();
        buffer.writeBytes(this.msgToSend);
        this.ctx.writeAndFlush((Object)buffer);
        if (LOG.isDebugEnabled()) {
            LOG.debug(">> {}", (Object)ByteBufUtils.bytesToHexString((byte[])this.msgToSend));
            LOG.debug("message sent");
        }
        return true;
    }

    public void setCtx(ChannelHandlerContext ctx) {
        this.ctx = ctx;
    }
}

