/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.clients;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleClientFramer
extends ByteToMessageDecoder {
    public static final byte LENGTH_OF_HEADER = 8;
    private static final byte LENGTH_INDEX_IN_HEADER = 2;
    private static final Logger LOG = LoggerFactory.getLogger(SimpleClientFramer.class);

    public SimpleClientFramer() {
        LOG.trace("Creating OFFrameDecoder");
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOG.warn("Unexpected exception from downstream.", cause);
        ctx.close();
    }

    protected void decode(ChannelHandlerContext chc, ByteBuf bb, List<Object> list) throws Exception {
        if (bb.readableBytes() < 8) {
            LOG.debug("skipping bb - too few data for header: {}", (Object)bb.readableBytes());
            return;
        }
        int length = bb.getUnsignedShort(bb.readerIndex() + 2);
        if (bb.readableBytes() < length) {
            LOG.debug("skipping bb - too few data for msg: {} < {}", (Object)bb.readableBytes(), (Object)length);
            return;
        }
        LOG.debug("OF Protocol message received, type:{}", (Object)bb.getByte(bb.readerIndex() + 1));
        ByteBuf messageBuffer = bb.slice(bb.readerIndex(), length);
        list.add(messageBuffer);
        messageBuffer.retain();
        bb.skipBytes(length);
    }
}

