/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowjava.protocol.impl.clients;

import com.google.common.util.concurrent.SettableFuture;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.opendaylight.openflowjava.protocol.impl.clients.ScenarioHandler;
import org.opendaylight.openflowjava.util.ByteBufUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleClientHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleClientHandler.class);
    private static final int LENGTH_INDEX_IN_HEADER = 2;
    private SettableFuture<Boolean> isOnlineFuture;
    protected ScenarioHandler scenarioHandler;

    public SimpleClientHandler(SettableFuture<Boolean> isOnlineFuture, ScenarioHandler scenarioHandler) {
        this.isOnlineFuture = isOnlineFuture;
        this.scenarioHandler = scenarioHandler;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ByteBuf bb = (ByteBuf)msg;
        if (LOG.isDebugEnabled()) {
            LOG.debug("<< {}", (Object)ByteBufUtils.byteBufToHexString((ByteBuf)bb));
        }
        int length = bb.getUnsignedShort(bb.readerIndex() + 2);
        LOG.trace("SimpleClientHandler - start of read");
        byte[] message = new byte[length];
        bb.readBytes(message);
        this.scenarioHandler.addOfMsg(message);
        LOG.trace("end of read");
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        LOG.debug("Client is active");
        if (this.isOnlineFuture != null) {
            this.isOnlineFuture.set((Object)true);
            this.isOnlineFuture = null;
        }
        this.scenarioHandler.setCtx(ctx);
        this.scenarioHandler.start();
    }

    public void setScenario(ScenarioHandler scenarioHandler) {
        this.scenarioHandler = scenarioHandler;
    }
}

