/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.lib;

import io.netty.channel.Channel;
import io.netty.handler.ssl.SslHandler;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.cert.Certificate;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement(name="Connection")
public class OvsdbConnectionInfo {
    @XmlTransient
    private Channel channel;
    @XmlTransient
    private ConnectionType type;

    public OvsdbConnectionInfo(Channel channel, ConnectionType type) {
        this.channel = channel;
        this.type = type;
    }

    @XmlElement(name="remoteAddress")
    public InetAddress getRemoteAddress() {
        return ((InetSocketAddress)this.channel.remoteAddress()).getAddress();
    }

    @XmlElement(name="remotePort")
    public int getRemotePort() {
        return ((InetSocketAddress)this.channel.remoteAddress()).getPort();
    }

    @XmlElement(name="localAddress")
    public InetAddress getLocalAddress() {
        return ((InetSocketAddress)this.channel.localAddress()).getAddress();
    }

    @XmlElement(name="localPort")
    public int getLocalPort() {
        return ((InetSocketAddress)this.channel.localAddress()).getPort();
    }

    @XmlElement(name="connectionType")
    public ConnectionType getType() {
        return this.type;
    }

    @XmlElement(name="clientCertificate")
    public Certificate getCertificate() throws SSLPeerUnverifiedException {
        SslHandler sslHandler = (SslHandler)this.channel.pipeline().get("ssl");
        if (sslHandler != null) {
            return sslHandler.engine().getSession().getPeerCertificates()[0];
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.channel == null ? 0 : this.getRemoteAddress().hashCode());
        result = 31 * result + (this.type == null ? 0 : this.getRemotePort());
        result = 31 * result + (this.channel == null ? 0 : this.getLocalAddress().hashCode());
        result = 31 * result + (this.type == null ? 0 : this.getLocalPort());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OvsdbConnectionInfo other = (OvsdbConnectionInfo)obj;
        if (this.channel == null) {
            if (other.channel != null) {
                return false;
            }
        } else {
            if (!this.getRemoteAddress().equals(other.getRemoteAddress())) {
                return false;
            }
            if (!this.getLocalAddress().equals(other.getLocalAddress())) {
                return false;
            }
            if (this.getRemotePort() != other.getRemotePort()) {
                return false;
            }
            if (this.getLocalPort() != other.getLocalPort()) {
                return false;
            }
        }
        return this.type == other.type;
    }

    public String toString() {
        return "ConnectionInfo [Remote-address=" + this.getRemoteAddress().getHostAddress() + ", Remote-port=" + this.getRemotePort() + ", Local-address" + this.getLocalAddress().getHostAddress() + ", Local-port=" + this.getLocalPort() + ", type=" + this.type + "]";
    }

    public static enum ConnectionType {
        ACTIVE,
        PASSIVE;

    }

    public static enum SocketConnectionType {
        SSL,
        NON_SSL;

    }
}

