/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.lib.impl;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.opendaylight.ovsdb.lib.operations.Operation;
import org.opendaylight.ovsdb.lib.operations.OperationResult;

public final class FutureTransformUtils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    private FutureTransformUtils() {
    }

    public static ListenableFuture<List<OperationResult>> transformTransactResponse(ListenableFuture<List<JsonNode>> transactResponseFuture, List<Operation> operations) {
        return Futures.transform(transactResponseFuture, jsonNodes -> {
            ArrayList<OperationResult> operationResults = new ArrayList<OperationResult>();
            for (int index = 0; index < jsonNodes.size(); ++index) {
                OperationResult or;
                JsonNode jsonNode = (JsonNode)jsonNodes.get(index);
                if (jsonNode != null && jsonNode.size() > 0) {
                    if (index < operations.size()) {
                        Operation op = (Operation)operations.get(index);
                        switch (op.getOp()) {
                            case "select": {
                                or = new OperationResult();
                                or.setRows(op.getTableSchema().createRows(jsonNode));
                                break;
                            }
                            default: {
                                or = (OperationResult)OBJECT_MAPPER.convertValue((Object)jsonNode, OperationResult.class);
                                break;
                            }
                        }
                    } else {
                        or = (OperationResult)OBJECT_MAPPER.convertValue((Object)jsonNode, OperationResult.class);
                    }
                } else {
                    or = new OperationResult();
                }
                operationResults.add(or);
            }
            return operationResults;
        }, (Executor)MoreExecutors.directExecutor());
    }
}

