/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.lib.impl;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.AdaptiveRecvByteBufAllocator;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.util.concurrent.ThreadFactory;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.opendaylight.ovsdb.lib.impl.NettyBootstrapFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Component(service={NettyBootstrapFactory.class})
public final class NettyBootstrapFactoryImpl
implements NettyBootstrapFactory,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(NettyBootstrapFactoryImpl.class);
    private static final Provider PROVIDER = Epoll.isAvailable() ? new EpollProvider() : new NioProvider();
    private final EventLoopGroup bossGroup = PROVIDER.createGroup(new ThreadFactoryBuilder().setNameFormat("OVSDB listener-%d").build());
    private final EventLoopGroup workerGroup = PROVIDER.createGroup(new ThreadFactoryBuilder().setNameFormat("OVSDB connection-%d").build());

    @Inject
    @Activate
    public NettyBootstrapFactoryImpl() {
        LOG.info("OVSDB global Netty context started with {}", (Object)PROVIDER.name());
    }

    @Override
    @PreDestroy
    @Deactivate
    public void close() {
        LOG.info("OVSDB global Netty context terminating");
        this.bossGroup.shutdownGracefully().addListener(ignore -> LOG.info("OVSDB global server group terminated"));
        this.workerGroup.shutdownGracefully().addListener(ignore -> LOG.info("OVSDB global channel group terminated"));
    }

    @Override
    public Bootstrap newClient() {
        return (Bootstrap)((Bootstrap)((Bootstrap)PROVIDER.createBootstrap().group(this.workerGroup)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.RCVBUF_ALLOCATOR, (Object)new AdaptiveRecvByteBufAllocator(65535, 65535, 65535));
    }

    @Override
    public ServerBootstrap newServer() {
        return (ServerBootstrap)((ServerBootstrap)PROVIDER.createServerBootstrap().group(this.bossGroup, this.workerGroup).childOption(ChannelOption.TCP_NODELAY, (Object)true).option(ChannelOption.RCVBUF_ALLOCATOR, (Object)new AdaptiveRecvByteBufAllocator(65535, 65535, 65535))).option(ChannelOption.SO_BACKLOG, (Object)100);
    }

    private static abstract class Provider {
        private Provider() {
        }

        abstract String name();

        abstract EventLoopGroup createGroup(ThreadFactory var1);

        abstract Bootstrap createBootstrap();

        abstract ServerBootstrap createServerBootstrap();
    }

    private static final class EpollProvider
    extends Provider {
        private EpollProvider() {
        }

        @Override
        String name() {
            return "epoll(7)";
        }

        @Override
        EventLoopGroup createGroup(ThreadFactory threadFactory) {
            return new EpollEventLoopGroup(0, threadFactory);
        }

        @Override
        Bootstrap createBootstrap() {
            return (Bootstrap)new Bootstrap().channel(EpollSocketChannel.class);
        }

        @Override
        ServerBootstrap createServerBootstrap() {
            return (ServerBootstrap)new ServerBootstrap().channel(EpollServerSocketChannel.class);
        }
    }

    private static final class NioProvider
    extends Provider {
        private NioProvider() {
        }

        @Override
        String name() {
            return "java.nio";
        }

        @Override
        EventLoopGroup createGroup(ThreadFactory threadFactory) {
            return new NioEventLoopGroup(0, threadFactory);
        }

        @Override
        Bootstrap createBootstrap() {
            return (Bootstrap)new Bootstrap().channel(NioSocketChannel.class);
        }

        @Override
        ServerBootstrap createServerBootstrap() {
            return (ServerBootstrap)new ServerBootstrap().channel(NioServerSocketChannel.class);
        }
    }
}

