/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.lib.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.channel.Channel;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.opendaylight.ovsdb.lib.EchoServiceCallbackFilters;
import org.opendaylight.ovsdb.lib.LockAquisitionCallback;
import org.opendaylight.ovsdb.lib.LockStolenCallback;
import org.opendaylight.ovsdb.lib.MonitorCallBack;
import org.opendaylight.ovsdb.lib.MonitorHandle;
import org.opendaylight.ovsdb.lib.OvsdbClient;
import org.opendaylight.ovsdb.lib.OvsdbConnectionInfo;
import org.opendaylight.ovsdb.lib.error.ParsingException;
import org.opendaylight.ovsdb.lib.impl.FutureTransformUtils;
import org.opendaylight.ovsdb.lib.message.MonitorRequest;
import org.opendaylight.ovsdb.lib.message.OvsdbRPC;
import org.opendaylight.ovsdb.lib.message.TableUpdate;
import org.opendaylight.ovsdb.lib.message.TableUpdates;
import org.opendaylight.ovsdb.lib.message.TransactBuilder;
import org.opendaylight.ovsdb.lib.message.UpdateNotification;
import org.opendaylight.ovsdb.lib.notation.Row;
import org.opendaylight.ovsdb.lib.operations.Operation;
import org.opendaylight.ovsdb.lib.operations.OperationResult;
import org.opendaylight.ovsdb.lib.operations.TransactionBuilder;
import org.opendaylight.ovsdb.lib.schema.DatabaseSchema;
import org.opendaylight.ovsdb.lib.schema.GenericTableSchema;
import org.opendaylight.ovsdb.lib.schema.TableSchema;
import org.opendaylight.ovsdb.lib.schema.typed.TypedBaseTable;
import org.opendaylight.ovsdb.lib.schema.typed.TypedDatabaseSchema;
import org.opendaylight.ovsdb.lib.schema.typed.TypedReflections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OvsdbClientImpl
implements OvsdbClient {
    private static final Logger LOG = LoggerFactory.getLogger(OvsdbClientImpl.class);
    private ExecutorService executorService;
    private OvsdbRPC rpc;
    private final Map<String, TypedDatabaseSchema> schemas = new HashMap<String, TypedDatabaseSchema>();
    private final Map<String, CallbackContext> monitorCallbacks = new HashMap<String, CallbackContext>();
    private OvsdbRPC.Callback rpcCallback;
    private OvsdbConnectionInfo connectionInfo;
    private Channel channel;
    private boolean isConnectionPublished;
    private static final int NO_TIMEOUT = -1;
    private static final ThreadFactory THREAD_FACTORY_SSL = new ThreadFactoryBuilder().setNameFormat("OVSDB-PassiveConnection-SSL-%d").build();
    private static final ThreadFactory THREAD_FACTORY_NON_SSL = new ThreadFactoryBuilder().setNameFormat("OVSDB-PassiveConnection-Non-SSL-%d").build();

    public OvsdbClientImpl(OvsdbRPC rpc, Channel channel, OvsdbConnectionInfo.ConnectionType type, OvsdbConnectionInfo.SocketConnectionType socketConnType) {
        this.rpc = rpc;
        ThreadFactory threadFactory = this.getThreadFactory(type, socketConnType, channel.remoteAddress().toString());
        this.executorService = Executors.newCachedThreadPool(threadFactory);
        this.channel = channel;
        this.connectionInfo = new OvsdbConnectionInfo(channel, type);
    }

    private ThreadFactory getThreadFactory(OvsdbConnectionInfo.ConnectionType type, OvsdbConnectionInfo.SocketConnectionType socketConnType, String executorNameArgs) {
        if (type == OvsdbConnectionInfo.ConnectionType.PASSIVE) {
            switch (socketConnType) {
                case SSL: {
                    return THREAD_FACTORY_SSL;
                }
                case NON_SSL: {
                    return THREAD_FACTORY_NON_SSL;
                }
            }
            return Executors.defaultThreadFactory();
        }
        if (type == OvsdbConnectionInfo.ConnectionType.ACTIVE) {
            ThreadFactory threadFactorySSL = new ThreadFactoryBuilder().setNameFormat("OVSDB-ActiveConn-" + executorNameArgs + "-%d").build();
            return threadFactorySSL;
        }
        return Executors.defaultThreadFactory();
    }

    OvsdbClientImpl() {
    }

    void setupUpdateListener() {
        if (this.rpcCallback == null) {
            OvsdbRPC.Callback temp;
            this.rpcCallback = temp = new OvsdbRPC.Callback(){

                @Override
                public void update(Object node, UpdateNotification updateNotification) {
                    String key = updateNotification.getContext();
                    CallbackContext callbackContext = OvsdbClientImpl.this.monitorCallbacks.get(key);
                    MonitorCallBack monitorCallBack = callbackContext.monitorCallBack;
                    if (monitorCallBack == null) {
                        LOG.info("callback received with context {}, but no known handler. Ignoring!", (Object)key);
                        return;
                    }
                    TableUpdates updates = OvsdbClientImpl.this.transformingCallback(updateNotification.getUpdates(), callbackContext.schema);
                    monitorCallBack.update(updates, callbackContext.schema);
                }

                @Override
                public void locked(Object node, List<String> ids) {
                }

                @Override
                public void stolen(Object node, List<String> ids) {
                }
            };
            this.rpc.registerCallback(temp);
        }
    }

    protected TableUpdates transformingCallback(JsonNode tableUpdatesJson, DatabaseSchema dbSchema) {
        if (tableUpdatesJson instanceof ObjectNode) {
            HashMap<String, TableUpdate> tableUpdateMap = new HashMap<String, TableUpdate>();
            ObjectNode updatesJson = (ObjectNode)tableUpdatesJson;
            Iterator itr = updatesJson.fields();
            while (itr.hasNext()) {
                Map.Entry entry = (Map.Entry)itr.next();
                DatabaseSchema databaseSchema = this.schemas.get(dbSchema.getName());
                TableSchema table = databaseSchema.table((String)entry.getKey(), TableSchema.class);
                tableUpdateMap.put((String)entry.getKey(), table.updatesFromJson((JsonNode)entry.getValue()));
            }
            return new TableUpdates(tableUpdateMap);
        }
        return null;
    }

    @Override
    public ListenableFuture<List<OperationResult>> transact(DatabaseSchema dbSchema, List<Operation> operations) {
        TransactBuilder builder = new TransactBuilder(dbSchema);
        for (Operation operation : operations) {
            builder.addOperation(operation);
        }
        return FutureTransformUtils.transformTransactResponse(this.rpc.transact(builder), operations);
    }

    @Override
    public <E extends TableSchema<E>> TableUpdates monitor(DatabaseSchema dbSchema, List<MonitorRequest> monitorRequest, MonitorCallBack callback) {
        return this.monitor(dbSchema, monitorRequest, callback, -1);
    }

    @Override
    public <E extends TableSchema<E>> TableUpdates monitor(DatabaseSchema dbSchema, List<MonitorRequest> monitorRequest, MonitorCallBack callback, int timeout) {
        return this.monitor(dbSchema, monitorRequest, new MonitorHandle(UUID.randomUUID().toString()), callback, timeout);
    }

    @Override
    public <E extends TableSchema<E>> TableUpdates monitor(DatabaseSchema dbSchema, List<MonitorRequest> monitorRequest, MonitorHandle monitorHandle, MonitorCallBack callback) {
        return this.monitor(dbSchema, monitorRequest, monitorHandle, callback, -1);
    }

    @Override
    public <E extends TableSchema<E>> TableUpdates monitor(DatabaseSchema dbSchema, List<MonitorRequest> monitorRequest, MonitorHandle monitorHandle, MonitorCallBack callback, int timeout) {
        JsonNode result;
        ImmutableMap reqMap = Maps.uniqueIndex(monitorRequest, MonitorRequest::getTableName);
        this.registerCallback(monitorHandle, callback, dbSchema);
        ListenableFuture<JsonNode> monitor = this.rpc.monitor(() -> Arrays.asList(dbSchema.getName(), monitorHandle.getId(), reqMap));
        try {
            result = timeout == -1 ? (JsonNode)monitor.get() : (JsonNode)monitor.get((long)timeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LOG.warn("Failed to monitor {}", (Object)dbSchema, (Object)e);
            return null;
        }
        return this.transformingCallback(result, dbSchema);
    }

    private void registerCallback(MonitorHandle monitorHandle, MonitorCallBack callback, DatabaseSchema schema) {
        this.monitorCallbacks.put(monitorHandle.getId(), new CallbackContext(callback, schema));
        this.setupUpdateListener();
    }

    @Override
    public void cancelMonitor(MonitorHandle handler) {
        this.cancelMonitor(handler, -1);
    }

    @Override
    public void cancelMonitor(MonitorHandle handler, int timeout) {
        ListenableFuture<JsonNode> cancelMonitor = this.rpc.monitor_cancel(() -> Collections.singletonList(handler.getId()));
        JsonNode result = null;
        try {
            result = timeout == -1 ? (JsonNode)cancelMonitor.get() : (JsonNode)cancelMonitor.get((long)timeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            LOG.error("Exception when canceling monitor handler {}", (Object)handler.getId(), (Object)e);
        }
        if (result == null) {
            LOG.error("Fail to cancel monitor with handler {}", (Object)handler.getId());
        } else {
            LOG.debug("Successfully cancel monitoring for handler {}", (Object)handler.getId());
        }
    }

    @Override
    public ListenableFuture<List<String>> echo() {
        return this.rpc.echo();
    }

    @Override
    public void lock(String lockId, LockAquisitionCallback lockedCallBack, LockStolenCallback stolenCallback) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public ListenableFuture<Boolean> steal(String lockId) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public ListenableFuture<Boolean> unLock(String lockId) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public void startEchoService(EchoServiceCallbackFilters callbackFilters) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public void stopEchoService() {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @Override
    public TransactionBuilder transactBuilder(DatabaseSchema dbSchema) {
        return new TransactionBuilder(this, dbSchema);
    }

    public boolean isReady(int timeout) throws InterruptedException {
        while (timeout > 0) {
            if (!this.schemas.isEmpty()) {
                return true;
            }
            Thread.sleep(1000L);
            --timeout;
        }
        return false;
    }

    @Override
    public ListenableFuture<List<String>> getDatabases() {
        return this.rpc.list_dbs();
    }

    @Override
    public ListenableFuture<TypedDatabaseSchema> getSchema(String database) {
        TypedDatabaseSchema existing = this.schemas.get(database);
        if (existing != null) {
            return Futures.immediateFuture((Object)existing);
        }
        return Futures.transform(this.getSchemaFromDevice(Collections.singletonList(database)), result -> {
            DatabaseSchema dbSchema = (DatabaseSchema)result.get(database);
            if (dbSchema == null) {
                return null;
            }
            TypedDatabaseSchema typedSchema = TypedDatabaseSchema.of(dbSchema.withInternallyGeneratedColumns());
            TypedDatabaseSchema raced = this.schemas.putIfAbsent(database, typedSchema);
            return raced != null ? raced : typedSchema;
        }, (Executor)this.executorService);
    }

    private ListenableFuture<Map<String, DatabaseSchema>> getSchemaFromDevice(List<String> dbNames) {
        HashMap<String, DatabaseSchema> schema = new HashMap<String, DatabaseSchema>();
        SettableFuture future = SettableFuture.create();
        this.populateSchema(dbNames, schema, (SettableFuture<Map<String, DatabaseSchema>>)future);
        return future;
    }

    private void populateSchema(List<String> dbNames, Map<String, DatabaseSchema> schema, SettableFuture<Map<String, DatabaseSchema>> sfuture) {
        if (dbNames == null || dbNames.isEmpty()) {
            return;
        }
        Futures.transform(this.rpc.get_schema(Collections.singletonList(dbNames.get(0))), jsonNode -> {
            try {
                schema.put((String)dbNames.get(0), DatabaseSchema.fromJson((String)dbNames.get(0), jsonNode));
                if (schema.size() > 1 && !sfuture.isCancelled()) {
                    this.populateSchema(dbNames.subList(1, dbNames.size()), schema, sfuture);
                } else if (schema.size() == 1) {
                    sfuture.set((Object)schema);
                }
            }
            catch (ParsingException e) {
                LOG.warn("Failed to populate schema {}:{}", new Object[]{dbNames, schema, e});
                sfuture.setException((Throwable)e);
            }
            return null;
        }, (Executor)MoreExecutors.directExecutor());
    }

    public void setRpc(OvsdbRPC rpc) {
        this.rpc = rpc;
    }

    @Override
    public TypedDatabaseSchema getDatabaseSchema(String dbName) {
        return this.schemas.get(dbName);
    }

    private <T> TypedDatabaseSchema getDatabaseSchemaForTypedTable(Class<T> klazz) {
        String dbName = TypedReflections.getTableDatabase(klazz);
        return dbName == null ? null : this.getDatabaseSchema(dbName);
    }

    @Override
    public <T extends TypedBaseTable<?>> T createTypedRowWrapper(Class<T> klazz) {
        return this.getTypedRowWrapper(klazz, new Row<GenericTableSchema>());
    }

    @Override
    public <T extends TypedBaseTable<?>> T createTypedRowWrapper(DatabaseSchema dbSchema, Class<T> klazz) {
        return dbSchema == null ? null : (T)TypedDatabaseSchema.of(dbSchema).getTypedRowWrapper(klazz, new Row<GenericTableSchema>());
    }

    @Override
    public <T extends TypedBaseTable<?>> T getTypedRowWrapper(Class<T> klazz, Row<GenericTableSchema> row) {
        TypedDatabaseSchema dbSchema = this.getDatabaseSchemaForTypedTable(klazz);
        return dbSchema == null ? null : (T)dbSchema.getTypedRowWrapper(klazz, row);
    }

    @Override
    public OvsdbConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    @Override
    public boolean isActive() {
        return this.channel.isActive();
    }

    @Override
    public void disconnect() {
        this.channel.disconnect();
        this.executorService.shutdown();
    }

    @Override
    public boolean isConnectionPublished() {
        return this.isConnectionPublished;
    }

    @Override
    public void setConnectionPublished(boolean connectionPublished) {
        this.isConnectionPublished = connectionPublished;
    }

    static class CallbackContext {
        MonitorCallBack monitorCallBack;
        DatabaseSchema schema;

        CallbackContext(MonitorCallBack monitorCallBack, DatabaseSchema schema) {
            this.monitorCallBack = monitorCallBack;
            this.schema = schema;
        }
    }
}

