/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.lib.impl;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.opendaylight.ovsdb.lib.OvsdbClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StalePassiveConnectionService
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(StalePassiveConnectionService.class);
    private final Map<OvsdbClient, Set<OvsdbClient>> pendingClients = new ConcurrentHashMap<OvsdbClient, Set<OvsdbClient>>();
    private final Function<OvsdbClient, Void> clientNotificationCallback;

    public StalePassiveConnectionService(Function<OvsdbClient, Void> clientNotificationCallback) {
        this.clientNotificationCallback = clientNotificationCallback;
    }

    public Map<OvsdbClient, Set<OvsdbClient>> getPendingClients() {
        return new HashMap<OvsdbClient, Set<OvsdbClient>>(this.pendingClients);
    }

    public void handleNewPassiveConnection(OvsdbClient newOvsdbClient, List<OvsdbClient> clientsFromSameNode) {
        LOG.info("Adding client to pending list {}", (Object)newOvsdbClient.getConnectionInfo());
        this.pendingClients.put(newOvsdbClient, new HashSet());
        for (final OvsdbClient oldClient : clientsFromSameNode) {
            this.pendingClients.get(newOvsdbClient).add(oldClient);
            LOG.info("Echo testing client {}", (Object)oldClient.getConnectionInfo());
            Futures.addCallback(oldClient.echo(), (FutureCallback)new FutureCallback<List<String>>(){

                public void onSuccess(List<String> result) {
                    LOG.info("Echo testing of old client {} succeeded", (Object)oldClient.getConnectionInfo());
                }

                public void onFailure(Throwable throwable) {
                    LOG.info("Echo testing of old client {} failed, disconnect and notify clients", (Object)oldClient.getConnectionInfo());
                    oldClient.disconnect();
                    StalePassiveConnectionService.this.onInactiveClient(oldClient);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }
    }

    public synchronized void clientDisconnected(OvsdbClient disconnectedClient) {
        LOG.info("Client disconnected {}", (Object)disconnectedClient.getConnectionInfo());
        this.onInactiveClient(disconnectedClient);
    }

    public synchronized void onInactiveClient(OvsdbClient disconnectedClient) {
        this.pendingClients.remove(disconnectedClient);
        this.pendingClients.entrySet().stream().forEach(entry -> ((Set)entry.getValue()).remove(disconnectedClient));
        Optional<OvsdbClient> clientOptional = this.pendingClients.entrySet().stream().filter(entry -> ((Set)entry.getValue()).isEmpty()).map(entry -> (OvsdbClient)entry.getKey()).findFirst();
        if (clientOptional.isPresent()) {
            OvsdbClient client = clientOptional.orElseThrow();
            LOG.info("Sending notification for client {}", (Object)client.getConnectionInfo());
            this.pendingClients.remove(client);
            this.clientNotificationCallback.apply(client);
        }
    }

    @Override
    public void close() {
    }
}

