/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.lib.jsonrpc;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.ReadTimeoutException;
import java.io.IOException;
import org.opendaylight.ovsdb.lib.OvsdbClient;
import org.opendaylight.ovsdb.lib.OvsdbConnection;
import org.opendaylight.ovsdb.lib.error.InvalidEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionHandler
extends ChannelDuplexHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ExceptionHandler.class);
    private final OvsdbConnection ovsdbConnectionService;

    public ExceptionHandler(OvsdbConnection ovsdbConnectionService) {
        this.ovsdbConnectionService = ovsdbConnectionService;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (ctx.channel().isActive()) {
            LOG.warn("Exception occurred while processing connection pipeline", cause);
            if (cause instanceof InvalidEncodingException || cause instanceof TooLongFrameException || cause instanceof DecoderException) {
                LOG.info("Disconnecting channel to ovsdb {}", (Object)ctx.channel());
                ctx.channel().disconnect();
                return;
            }
            if (cause instanceof IOException || cause instanceof ReadTimeoutException) {
                LOG.info("Closing channel to ovsdb {}", (Object)ctx.channel());
                ctx.channel().close();
                return;
            }
            LOG.error("Exception was not handled by the exception handler, re-throwing it for next handler");
            ctx.fireExceptionCaught(cause);
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt instanceof IdleStateEvent) {
            LOG.debug("Get idle state event");
            IdleStateEvent event = (IdleStateEvent)evt;
            if (event.state() == IdleState.READER_IDLE) {
                LOG.debug("Reader idle state. Send echo message to peer");
                OvsdbClient client = this.ovsdbConnectionService.getClient(ctx.channel());
                client.echo();
            }
        }
    }
}

