/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.lib.jsonrpc;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.json.ByteSourceJsonBootstrapper;
import com.fasterxml.jackson.core.util.BufferRecycler;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.opendaylight.ovsdb.lib.error.InvalidEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRpcDecoder
extends ByteToMessageDecoder {
    private static final Logger LOG = LoggerFactory.getLogger(JsonRpcDecoder.class);
    private static final JsonFactory JSON_FACTORY = new MappingJsonFactory();
    private final int maxFrameLength;
    private boolean maxFrameLimitWasReached = false;
    private final IOContext jacksonIOContext = new IOContext(new BufferRecycler(), null, false);
    private int lastRecordBytes = 0;
    private int leftCurlies = 0;
    private int rightCurlies = 0;
    private boolean inS = false;
    private int recordsRead;

    public JsonRpcDecoder(int maxFrameLength) {
        this.maxFrameLength = maxFrameLength;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws IOException {
        int index;
        LOG.trace("readable bytes {}, records read {}, incomplete record bytes {}", new Object[]{buf.readableBytes(), this.recordsRead, this.lastRecordBytes});
        if (this.lastRecordBytes == 0) {
            if (buf.readableBytes() < 4) {
                return;
            }
            JsonRpcDecoder.skipSpaces(buf);
            byte[] buff = new byte[4];
            buf.getBytes(buf.readerIndex(), buff);
            ByteSourceJsonBootstrapper strapper = new ByteSourceJsonBootstrapper(this.jacksonIOContext, buff, 0, 4);
            JsonEncoding jsonEncoding = strapper.detectEncoding();
            if (!JsonEncoding.UTF8.equals((Object)jsonEncoding)) {
                throw new InvalidEncodingException(jsonEncoding.getJavaName(), "currently only UTF-8 is supported");
            }
        }
        for (index = this.lastRecordBytes + buf.readerIndex(); index < buf.writerIndex(); ++index) {
            switch (buf.getByte(index)) {
                case 123: {
                    if (this.inS) break;
                    ++this.leftCurlies;
                    break;
                }
                case 125: {
                    if (this.inS) break;
                    ++this.rightCurlies;
                    break;
                }
                case 34: {
                    if (buf.getByte(index - 1) == 92) break;
                    this.inS = !this.inS;
                    break;
                }
            }
            if (this.leftCurlies != 0 && this.leftCurlies == this.rightCurlies && !this.inS) {
                ByteBuf slice = buf.readSlice(1 + index - buf.readerIndex());
                JsonParser jp = JSON_FACTORY.createParser((InputStream)new ByteBufInputStream(slice));
                JsonNode root = (JsonNode)jp.readValueAsTree();
                out.add(root);
                this.leftCurlies = 0;
                this.rightCurlies = 0;
                this.lastRecordBytes = 0;
                ++this.recordsRead;
                break;
            }
            if (index - buf.readerIndex() < this.maxFrameLength || this.maxFrameLimitWasReached) continue;
            this.maxFrameLimitWasReached = true;
            LOG.warn("***** OVSDB Frame limit of {} bytes has been reached! *****", (Object)this.maxFrameLength);
        }
        if (index >= buf.writerIndex()) {
            this.lastRecordBytes = buf.readableBytes();
        }
    }

    public int getRecordsRead() {
        return this.recordsRead;
    }

    private static void skipSpaces(ByteBuf byteBuf) throws IOException {
        while (byteBuf.isReadable()) {
            int ch = byteBuf.getByte(byteBuf.readerIndex()) & 0xFF;
            if (ch != 32 && ch != 13 && ch != 10 && ch != 9) {
                return;
            }
            byteBuf.readByte();
        }
    }
}

