/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.lib.jsonrpc;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.opendaylight.ovsdb.lib.error.UnsupportedArgumentException;
import org.opendaylight.ovsdb.lib.jsonrpc.JsonRpc10Request;
import org.opendaylight.ovsdb.lib.jsonrpc.JsonRpc10Response;
import org.opendaylight.ovsdb.lib.jsonrpc.Params;
import org.opendaylight.ovsdb.lib.message.OvsdbRPC;
import org.opendaylight.ovsdb.lib.message.Response;
import org.opendaylight.ovsdb.lib.message.TransactBuilder;
import org.opendaylight.ovsdb.lib.message.UpdateNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRpcEndpoint
extends ChannelInboundHandlerAdapter
implements OvsdbRPC {
    private static final Logger LOG = LoggerFactory.getLogger(JsonRpcEndpoint.class);
    private static final int REAPER_THREADS = 3;
    private static final ThreadFactory FUTURE_REAPER_THREAD_FACTORY = new ThreadFactoryBuilder().setNameFormat("OVSDB-Lib-Future-Reaper-%d").setDaemon(true).build();
    private static final ScheduledExecutorService FUTURE_REAPER_SERVICE = Executors.newScheduledThreadPool(3, FUTURE_REAPER_THREAD_FACTORY);
    private static final JavaType JT_OBJECT = TypeFactory.defaultInstance().constructType(Object.class);
    private static final JavaType JT_JSON_NODE = TypeFactory.defaultInstance().constructType(JsonNode.class);
    private static final JavaType JT_LIST_JSON_NODE = TypeFactory.defaultInstance().constructParametricType(List.class, new Class[]{JsonNode.class});
    private static final JavaType JT_LIST_STRING = TypeFactory.defaultInstance().constructParametricType(List.class, new Class[]{String.class});
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    private static int reaperInterval = 1000;
    private final Map<String, CallContext> methodContext = new ConcurrentHashMap<String, CallContext>();
    private final Channel nettyChannel;
    private volatile OvsdbRPC.Callback currentCallback = null;

    public JsonRpcEndpoint(Channel channel) {
        this.nettyChannel = Objects.requireNonNull(channel);
    }

    public static void setReaperInterval(int interval) {
        reaperInterval = interval;
        LOG.info("Ovsdb Rpc Task interval is set to {} millisecond", (Object)reaperInterval);
    }

    public static void close() {
        LOG.info("Shutting down reaper executor service");
        FUTURE_REAPER_SERVICE.shutdownNow();
    }

    @Override
    public ListenableFuture<JsonNode> get_schema(List<String> dbNames) {
        return this.sendRequest(JT_JSON_NODE, "get_schema", dbNames);
    }

    @Override
    public ListenableFuture<List<String>> echo() {
        return this.sendRequest(JT_LIST_STRING, "echo");
    }

    @Override
    public ListenableFuture<JsonNode> monitor(Params equest) {
        return this.sendRequest(JT_JSON_NODE, "monitor", equest);
    }

    @Override
    public ListenableFuture<List<String>> list_dbs() {
        return this.sendRequest(JT_LIST_STRING, "list_dbs");
    }

    @Override
    public ListenableFuture<List<JsonNode>> transact(TransactBuilder transact) {
        return this.sendRequest(JT_LIST_JSON_NODE, "transact", transact);
    }

    @Override
    public ListenableFuture<Response> cancel(String id) {
        throw new UnsupportedArgumentException("do not understand this argument yet");
    }

    @Override
    public ListenableFuture<JsonNode> monitor_cancel(Params jsonValue) {
        return this.sendRequest(JT_JSON_NODE, "monitor_cancel", jsonValue);
    }

    @Override
    public ListenableFuture<Object> lock(List<String> id) {
        return this.sendRequest(JT_OBJECT, "lock", id);
    }

    @Override
    public ListenableFuture<Object> steal(List<String> id) {
        return this.sendRequest(JT_OBJECT, "steal", id);
    }

    @Override
    public ListenableFuture<Object> unlock(List<String> id) {
        return this.sendRequest(JT_OBJECT, "unlock", id);
    }

    @Override
    public boolean registerCallback(OvsdbRPC.Callback callback) {
        if (callback == null) {
            return false;
        }
        this.currentCallback = callback;
        return true;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!(msg instanceof JsonNode)) {
            LOG.debug("Unexpected message {}, closing channel {}", msg, (Object)this.nettyChannel);
            ctx.channel().close();
            return;
        }
        JsonNode jsonNode = (JsonNode)msg;
        JsonNode result = jsonNode.get("result");
        if (result != null) {
            this.handleResponse(jsonNode, result);
            return;
        }
        JsonNode method = jsonNode.get("method");
        if (method != null && !method.isNull()) {
            this.handleRequest(jsonNode, method);
            return;
        }
        LOG.debug("Ignoring message {} on channel {}", (Object)jsonNode, (Object)this.nettyChannel);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    private void handleRequest(JsonNode jsonRequest, JsonNode jsonMethod) {
        String method;
        JsonNode id = jsonRequest.get("id");
        JsonNode params = jsonRequest.get("params");
        if (id == null) {
            LOG.debug("Ignoring request with non-existent id field: {} {}", (Object)jsonMethod, (Object)params);
            return;
        }
        String requestId = id.asText();
        if (Strings.isNullOrEmpty((String)requestId)) {
            LOG.debug("Ignoring equest with null or empty id field: {} {}", (Object)jsonMethod, (Object)params);
            return;
        }
        LOG.trace("Request : {} {} {}", new Object[]{id, jsonMethod, params});
        switch (method = jsonMethod.asText()) {
            case "echo": {
                this.sendEmptyResponse(requestId);
                return;
            }
            case "list_dbs": {
                this.sendEmptyResponse(requestId);
                return;
            }
        }
        if (!this.handleCallbackRequest(this.currentCallback, requestId, method, params)) {
            LOG.error("No handler for Request : {} on {}", (Object)jsonRequest, (Object)this.nettyChannel);
        }
    }

    private boolean handleCallbackRequest(OvsdbRPC.Callback callback, String requestId, String method, JsonNode params) {
        if (callback == null) {
            return false;
        }
        switch (method) {
            case "update": {
                UpdateNotification arg;
                try {
                    arg = (UpdateNotification)OBJECT_MAPPER.convertValue((Object)params, UpdateNotification.class);
                }
                catch (IllegalArgumentException e) {
                    return this.reportedMalformedParameters(requestId, e);
                }
                callback.update(this.nettyChannel, arg);
                return true;
            }
            case "locked": {
                List arg;
                try {
                    arg = (List)OBJECT_MAPPER.convertValue((Object)params, JT_LIST_STRING);
                }
                catch (IllegalArgumentException e) {
                    return this.reportedMalformedParameters(requestId, e);
                }
                callback.locked(this.nettyChannel, arg);
                return true;
            }
            case "stolen": {
                List arg;
                try {
                    arg = (List)OBJECT_MAPPER.convertValue((Object)params, JT_LIST_STRING);
                }
                catch (IllegalArgumentException e) {
                    return this.reportedMalformedParameters(requestId, e);
                }
                callback.stolen(this.nettyChannel, arg);
                return true;
            }
        }
        return false;
    }

    private boolean reportedMalformedParameters(String requestId, Exception cause) {
        LOG.debug("Request {} failed to map parameters", (Object)requestId, (Object)cause);
        this.sendErrorResponse(requestId, cause.getMessage());
        return true;
    }

    private void sendEmptyResponse(String requestId) {
        this.sendErrorResponse(requestId, null);
    }

    private void sendErrorResponse(String requestId, String error) {
        String jsonString;
        JsonRpc10Response response = new JsonRpc10Response(requestId);
        response.setError(error);
        try {
            jsonString = OBJECT_MAPPER.writeValueAsString((Object)response);
        }
        catch (JsonProcessingException e) {
            LOG.error("Exception while processing JSON response {}", (Object)response, (Object)e);
            return;
        }
        this.nettyChannel.writeAndFlush((Object)jsonString);
    }

    private void handleResponse(JsonNode response, JsonNode result) {
        Object mappedResult;
        LOG.trace("Response : {}", (Object)response);
        String requestId = response.get("id").asText();
        CallContext returnCtxt = this.methodContext.remove(requestId);
        if (returnCtxt == null) {
            LOG.debug("Ignoring response for unknown request {}", (Object)requestId);
            return;
        }
        JsonNode error = response.get("error");
        if (error != null && !error.isNull()) {
            LOG.error("Request {} failed with error {}", (Object)requestId, (Object)error);
        }
        if (!returnCtxt.future.set(mappedResult = OBJECT_MAPPER.convertValue((Object)result, returnCtxt.resultType))) {
            LOG.debug("Request {} did not accept result {}", (Object)requestId, mappedResult);
        }
    }

    private <T> ListenableFuture<T> sendRequest(JsonRpc10Request request, JavaType resultType) {
        String requestString;
        try {
            requestString = OBJECT_MAPPER.writeValueAsString((Object)request);
        }
        catch (JsonProcessingException e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
        LOG.trace("getClient Request : {}", (Object)requestString);
        SettableFuture sf = SettableFuture.create();
        this.methodContext.put(request.getId(), new CallContext(resultType, sf));
        FUTURE_REAPER_SERVICE.schedule(() -> {
            CallContext cc = this.methodContext.remove(request.getId());
            if (cc != null) {
                if (cc.future.isDone() || cc.future.isCancelled()) {
                    return;
                }
                cc.future.cancel(false);
            }
        }, (long)reaperInterval, TimeUnit.MILLISECONDS);
        this.nettyChannel.writeAndFlush((Object)requestString);
        return sf;
    }

    private <T> ListenableFuture<T> sendRequest(JavaType resultType, String method) {
        return this.sendRequest(JsonRpcEndpoint.createRequest(method), resultType);
    }

    private <T> ListenableFuture<T> sendRequest(JavaType resultType, String method, List params) {
        JsonRpc10Request request = JsonRpcEndpoint.createRequest(method);
        request.setParams(params);
        return this.sendRequest(request, resultType);
    }

    private <T> ListenableFuture<T> sendRequest(JavaType resultType, String method, Params params) {
        JsonRpc10Request request = JsonRpcEndpoint.createRequest(method);
        request.setParams(params.params());
        return this.sendRequest(request, resultType);
    }

    private static JsonRpc10Request createRequest(String method) {
        JsonRpc10Request request = new JsonRpc10Request(UUID.randomUUID().toString());
        request.setMethod(method);
        return request;
    }

    private static final class CallContext {
        final JavaType resultType;
        final SettableFuture future;

        CallContext(JavaType resultType, SettableFuture future) {
            this.resultType = resultType;
            this.future = future;
        }
    }
}

