/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.lib.message;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.opendaylight.ovsdb.lib.message.MonitorRequest;
import org.opendaylight.ovsdb.lib.message.MonitorSelect;
import org.opendaylight.ovsdb.lib.schema.ColumnSchema;
import org.opendaylight.ovsdb.lib.schema.TableSchema;

public class MonitorRequestBuilder<E extends TableSchema<E>> {
    private final E tableSchema;
    private final Collection<String> columns = new HashSet<String>();
    private MonitorSelect select;

    public MonitorRequestBuilder(E tableSchema) {
        this.tableSchema = tableSchema;
    }

    public MonitorRequestBuilder<E> addColumn(String column) {
        this.columns.add(column);
        return this;
    }

    public MonitorRequestBuilder<E> addColumn(ColumnSchema<?, ?> column) {
        this.addColumn(column.getName());
        return this;
    }

    public MonitorRequestBuilder<E> addColumns(Collection<String> extraColumns) {
        this.columns.addAll(extraColumns);
        return this;
    }

    public MonitorRequestBuilder<E> addColumns(List<ColumnSchema<E, ?>> extraColumns) {
        for (ColumnSchema<E, ?> schema : extraColumns) {
            this.addColumn(schema);
        }
        return this;
    }

    public Collection<String> getColumns() {
        return this.columns;
    }

    public MonitorRequestBuilder<E> with(MonitorSelect what) {
        this.select = what;
        return this;
    }

    public MonitorRequest build() {
        MonitorRequest request = new MonitorRequest(((TableSchema)this.tableSchema).getName(), new HashSet<String>(this.columns));
        request.setSelect(this.select == null ? new MonitorSelect() : this.select);
        return request;
    }
}

