/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.lib.message;

import java.util.HashMap;
import java.util.Map;
import org.opendaylight.ovsdb.lib.notation.Row;
import org.opendaylight.ovsdb.lib.notation.UUID;
import org.opendaylight.ovsdb.lib.schema.TableSchema;

public class TableUpdate<E extends TableSchema<E>> {
    private final Map<UUID, RowUpdate<E>> rows = new HashMap<UUID, RowUpdate<E>>();

    public Map<UUID, RowUpdate<E>> getRows() {
        return this.rows;
    }

    public void addRow(UUID uuid, Row<E> oldRow, Row<E> newRow) {
        this.rows.put(uuid, new RowUpdate<E>(uuid, oldRow, newRow));
    }

    public Row<E> getOld(UUID uuid) {
        RowUpdate<E> rowUpdate = this.rows.get(uuid);
        return rowUpdate != null ? rowUpdate.getOld() : null;
    }

    public Row<E> getNew(UUID uuid) {
        RowUpdate<E> rowUpdate = this.rows.get(uuid);
        return rowUpdate != null ? rowUpdate.getNew() : null;
    }

    public String toString() {
        return "TableUpdate [" + this.rows + "]";
    }

    public static final class RowUpdate<E extends TableSchema<E>> {
        private final UUID uuid;
        private final Row<E> oldRow;
        private final Row<E> newRow;

        public RowUpdate(UUID uuid, Row<E> oldRow, Row<E> newRow) {
            this.uuid = uuid;
            this.oldRow = oldRow;
            this.newRow = newRow;
        }

        public UUID getUuid() {
            return this.uuid;
        }

        public Row<E> getOld() {
            return this.oldRow;
        }

        public Row<E> getNew() {
            return this.newRow;
        }

        public String toString() {
            return "RowUpdate [uuid=" + this.uuid + ", oldRow=" + this.oldRow + ", newRow=" + this.newRow + "]";
        }
    }
}

