/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.lib.notation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.opendaylight.ovsdb.lib.schema.ColumnSchema;
import org.opendaylight.ovsdb.lib.schema.TableSchema;

public class Column<E extends TableSchema<E>, D> {
    @JsonIgnore
    private ColumnSchema<E, D> schema;
    private D data;

    public Column(ColumnSchema<E, D> schema, D data) {
        this.schema = schema;
        this.data = data;
    }

    public <E extends TableSchema<E>, T> T getData(ColumnSchema<E, T> anotherSchema) {
        return anotherSchema.validate(this.data);
    }

    public D getData() {
        return this.data;
    }

    public void setData(D data) {
        this.data = data;
    }

    public ColumnSchema<E, D> getSchema() {
        return this.schema;
    }

    public void setSchema(ColumnSchema<E, D> schema) {
        this.schema = schema;
    }

    public String toString() {
        return "[" + this.schema.getName() + "=" + this.data + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        result = 31 * result + (this.schema == null ? 0 : this.schema.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Column other = (Column)obj;
        if (this.data == null ? other.data != null : !this.data.equals(other.data)) {
            return false;
        }
        return !(this.schema == null ? other.schema != null : !this.schema.equals(other.schema));
    }
}

