/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.lib.notation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.ovsdb.lib.notation.Column;
import org.opendaylight.ovsdb.lib.notation.json.RowSerializer;
import org.opendaylight.ovsdb.lib.schema.ColumnSchema;
import org.opendaylight.ovsdb.lib.schema.TableSchema;

@JsonSerialize(using=RowSerializer.class)
public class Row<E extends TableSchema<E>> {
    @JsonIgnore
    private TableSchema<E> tableSchema;
    protected Map<String, Column<E, ?>> columns = new HashMap();

    public Row() {
    }

    public Row(TableSchema<E> tableSchema) {
        this.tableSchema = tableSchema;
    }

    public Row(TableSchema<E> tableSchema, List<Column<E, ?>> columns) {
        this.tableSchema = tableSchema;
        for (Column<E, ?> column : columns) {
            this.columns.put(column.getSchema().getName(), column);
        }
    }

    public <D> Column<E, D> getColumn(ColumnSchema<E, D> schema) {
        return this.columns.get(schema.getName());
    }

    public Collection<Column<E, ?>> getColumns() {
        return this.columns.values();
    }

    public void addColumn(String columnName, Column<E, ?> data) {
        this.columns.put(columnName, data);
    }

    public TableSchema<E> getTableSchema() {
        return this.tableSchema;
    }

    public void setTableSchema(TableSchema<E> tableSchema) {
        this.tableSchema = tableSchema;
    }

    public String toString() {
        return "Row [columns=" + this.columns + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.columns == null ? 0 : this.columns.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Row other = (Row)obj;
        return !(this.columns == null ? other.columns != null : !this.columns.equals(other.columns));
    }
}

