/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.lib.notation;

import com.google.common.collect.Range;

public class Version
implements Comparable<Version> {
    private static final String FORMAT = "(\\d+)\\.(\\d+)\\.(\\d+)";
    private final int major;
    private final int minor;
    private final int patch;
    public static final Version NULL = new Version(0, 0, 0);
    public static final String NULL_VERSION_STRING = "0.0.0";

    public Version(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public static Version fromString(String version) {
        int firstDot = version.indexOf(46);
        int secondDot = version.indexOf(46, firstDot + 1);
        if (firstDot == -1 || secondDot == -1) {
            throw new IllegalArgumentException("<" + version + "> does not match format (\\d+)\\.(\\d+)\\.(\\d+)");
        }
        int major = Version.parse(version, 0, firstDot);
        int minor = Version.parse(version, firstDot + 1, secondDot);
        int patch = Version.parse(version, secondDot + 1, version.length());
        return new Version(major, minor, patch);
    }

    private static int parse(String string, int start, int end) {
        int result = 0;
        for (int i = start; i < end && i < string.length(); ++i) {
            char character = string.charAt(i);
            int digit = Character.digit(character, 10);
            if (digit < 0) {
                throw new IllegalArgumentException("Not a digit: " + character);
            }
            result = result * 10 + digit;
        }
        return result;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.patch;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Version other = (Version)obj;
        return this.major == other.major && this.minor == other.minor && this.patch == other.patch;
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.patch;
        return result;
    }

    @Override
    public int compareTo(Version version) {
        if (this.equals(version)) {
            return 0;
        }
        if (this.major > version.major) {
            return 1;
        }
        if (this.major < version.major) {
            return -1;
        }
        if (this.minor > version.minor) {
            return 1;
        }
        if (this.minor < version.minor) {
            return -1;
        }
        if (this.patch > version.patch) {
            return 1;
        }
        return -1;
    }

    public static Range<Version> createRangeOf(Version from, Version to) {
        if (from == null || NULL.equals(from)) {
            return to == null || NULL.equals(to) ? Range.all() : Range.atMost((Comparable)to);
        }
        return to == null || NULL.equals(to) ? Range.atLeast((Comparable)from) : Range.closed((Comparable)from, (Comparable)to);
    }
}

