/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.lib.notation.json;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.util.StdConverter;
import org.opendaylight.ovsdb.lib.message.TableUpdates;
import org.opendaylight.ovsdb.lib.message.UpdateNotification;
import org.opendaylight.ovsdb.lib.notation.OvsdbMap;
import org.opendaylight.ovsdb.lib.notation.OvsdbSet;
import org.opendaylight.ovsdb.lib.notation.UUID;

public final class Converter {
    static AtomDeser atomDeser = new AtomDeser();
    static MapDeser mapDeser = new MapDeser();
    static SetDeser setDeser = new SetDeser();
    static UpdateNotificationDeser unDeser = new UpdateNotificationDeser();

    private Converter() {
    }

    static class AtomDeser {
        AtomDeser() {
        }

        public Object deserialize(JsonNode node) {
            if (!node.isArray()) {
                switch (node.getNodeType()) {
                    case BOOLEAN: {
                        return node.asBoolean();
                    }
                    case NUMBER: {
                        if (node.isFloatingPointNumber()) {
                            return node.decimalValue();
                        }
                        return node.bigIntegerValue();
                    }
                    case STRING: {
                        return node.asText();
                    }
                }
            }
            if (node.isArray() && node.get(0).isTextual() && ("uuid".equals(node.get(0).asText()) || "named-uuid".equals(node.get(0).asText()))) {
                return new UUID(node.get(1).asText());
            }
            throw new IllegalArgumentException("not an atom node");
        }
    }

    static class MapDeser {
        MapDeser() {
        }

        public OvsdbMap<Object, Object> deserialize(JsonNode node) {
            if (node.isArray() && node.size() == 2) {
                if (node.get(0).isTextual() && "map".equals(node.get(0).asText())) {
                    OvsdbMap<Object, Object> map = new OvsdbMap<Object, Object>();
                    for (JsonNode pairNode : node.get(1)) {
                        if (!pairNode.isArray() || node.size() != 2) continue;
                        Object key = atomDeser.deserialize(pairNode.get(0));
                        Object value = atomDeser.deserialize(pairNode.get(1));
                        map.put(key, value);
                    }
                    return map;
                }
                if (node.size() == 0) {
                    return null;
                }
            }
            throw new IllegalArgumentException("not a map type");
        }
    }

    static class SetDeser {
        SetDeser() {
        }

        public OvsdbSet<Object> deserialize(JsonNode node) {
            Object atom;
            OvsdbSet<Object> set = new OvsdbSet<Object>();
            if (node.isArray()) {
                if (node.size() == 2) {
                    if (node.get(0).isTextual() && "set".equals(node.get(0).asText())) {
                        for (JsonNode atomNode : node.get(1)) {
                            set.add(atomDeser.deserialize(atomNode));
                        }
                        return set;
                    }
                } else if (node.size() == 0) {
                    return null;
                }
            }
            if (null != (atom = atomDeser.deserialize(node))) {
                set.add(atom);
            }
            return set;
        }
    }

    static class UpdateNotificationDeser {
        private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

        UpdateNotificationDeser() {
        }

        public UpdateNotification deserialize(JsonNode node) {
            UpdateNotification un = new UpdateNotification();
            if (node.isArray() && node.size() == 2) {
                un.setContext(node.get(0).asText());
                un.setUpdates(node.get(1));
                un.setUpdate((TableUpdates)OBJECT_MAPPER.convertValue((Object)node.get(1), TableUpdates.class));
                return un;
            }
            return null;
        }
    }

    public static class UpdateNotificationConverter
    extends StdConverter<JsonNode, UpdateNotification> {
        public UpdateNotification convert(JsonNode value) {
            return unDeser.deserialize(value);
        }
    }

    public static class SetConverter
    extends StdConverter<JsonNode, OvsdbSet<Object>> {
        public OvsdbSet<Object> convert(JsonNode value) {
            return setDeser.deserialize(value);
        }
    }

    public static class MapConverter
    extends StdConverter<JsonNode, OvsdbMap<Object, Object>> {
        public OvsdbMap<Object, Object> convert(JsonNode value) {
            return mapDeser.deserialize(value);
        }
    }
}

