/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.lib.operations;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.opendaylight.ovsdb.lib.notation.Row;
import org.opendaylight.ovsdb.lib.operations.Abort;
import org.opendaylight.ovsdb.lib.operations.Assert;
import org.opendaylight.ovsdb.lib.operations.Comment;
import org.opendaylight.ovsdb.lib.operations.Commit;
import org.opendaylight.ovsdb.lib.operations.Delete;
import org.opendaylight.ovsdb.lib.operations.Insert;
import org.opendaylight.ovsdb.lib.operations.Mutate;
import org.opendaylight.ovsdb.lib.operations.Operations;
import org.opendaylight.ovsdb.lib.operations.Select;
import org.opendaylight.ovsdb.lib.operations.Update;
import org.opendaylight.ovsdb.lib.schema.TableSchema;
import org.opendaylight.ovsdb.lib.schema.typed.TypedBaseTable;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Singleton
@Component
public final class DefaultOperations
implements Operations {
    @Inject
    @Activate
    public DefaultOperations() {
    }

    @Override
    public <E extends TableSchema<E>> Insert<E> insert(TableSchema<E> schema) {
        return new Insert<E>(schema);
    }

    @Override
    public <E extends TableSchema<E>> Insert<E> insert(TypedBaseTable<E> typedTable) {
        return new Insert<E>(typedTable);
    }

    @Override
    public <E extends TableSchema<E>> Insert<E> insert(TableSchema<E> schema, Row<E> row) {
        return new Insert<E>(schema, row);
    }

    @Override
    public <E extends TableSchema<E>> Update<E> update(TableSchema<E> schema) {
        return new Update<E>(schema);
    }

    @Override
    public <E extends TableSchema<E>> Update<E> update(TypedBaseTable<E> typedTable) {
        return new Update<E>(typedTable);
    }

    @Override
    public <E extends TableSchema<E>> Update<E> update(TableSchema<E> schema, Row<E> row) {
        return new Update<E>(schema, row);
    }

    @Override
    public <E extends TableSchema<E>> Delete<E> delete(TableSchema<E> schema) {
        return new Delete<E>(schema);
    }

    @Override
    public <E extends TableSchema<E>> Mutate<E> mutate(TableSchema<E> schema) {
        return new Mutate<E>(schema);
    }

    @Override
    public <E extends TableSchema<E>> Mutate<E> mutate(TypedBaseTable<E> typedTable) {
        return new Mutate(typedTable.getSchema());
    }

    @Override
    public Commit commit(Boolean durable) {
        return new Commit(durable);
    }

    @Override
    public Abort abort() {
        return new Abort();
    }

    @Override
    public <E extends TableSchema<E>> Select<E> select(TableSchema<E> schema) {
        return new Select<E>(schema);
    }

    @Override
    public Comment comment(String comment) {
        return new Comment(comment);
    }

    @Override
    public Assert assertion(String lock) {
        return new Assert(lock);
    }
}

