/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.lib.operations;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.opendaylight.ovsdb.lib.notation.Column;
import org.opendaylight.ovsdb.lib.notation.Row;
import org.opendaylight.ovsdb.lib.operations.Operation;
import org.opendaylight.ovsdb.lib.schema.ColumnSchema;
import org.opendaylight.ovsdb.lib.schema.TableSchema;
import org.opendaylight.ovsdb.lib.schema.typed.TypedBaseTable;

public class Insert<E extends TableSchema<E>>
extends Operation<E> {
    public static final String INSERT = "insert";
    String uuid;
    @JsonProperty(value="uuid-name")
    private String uuidName;
    private Map<String, Object> row = new HashMap<String, Object>();

    public Insert<E> on(TableSchema<E> schema) {
        this.setTableSchema(schema);
        return this;
    }

    public Insert<E> withId(String name) {
        this.uuidName = name;
        this.setOp(INSERT);
        return this;
    }

    public Insert(TableSchema<E> schema) {
        super(schema, INSERT);
    }

    public Insert(TableSchema<E> schema, Row<E> row) {
        super(schema, INSERT);
        Collection<Column<E, ?>> columns = row.getColumns();
        for (Column<E, ?> column : columns) {
            this.value(column);
        }
    }

    public Insert(TypedBaseTable<E> typedTable) {
        this((TableSchema<E>)typedTable.getSchema(), typedTable.getRow());
    }

    public <D, C extends TableSchema<C>> Insert<E> value(ColumnSchema<C, D> columnSchema, D value) {
        Object untypedValue = columnSchema.getNormalizeData(value);
        this.row.put(columnSchema.getName(), untypedValue);
        return this;
    }

    public <D, C extends TableSchema<C>> Insert<E> value(Column<C, D> column) {
        ColumnSchema<C, D> columnSchema = column.getSchema();
        D value = column.getData();
        return this.value(columnSchema, value);
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getUuidName() {
        return this.uuidName;
    }

    public void setUuidName(String uuidName) {
        this.uuidName = uuidName;
    }

    public Map<String, Object> getRow() {
        return this.row;
    }

    public void setRow(Map<String, Object> row) {
        this.row = row;
    }
}

