/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.lib.operations;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.opendaylight.ovsdb.lib.operations.OperationResult;
import org.opendaylight.ovsdb.lib.schema.TableSchema;

public abstract class Operation<E extends TableSchema<E>> {
    @JsonIgnore
    private TableSchema<E> tableSchema;
    private String op;
    @JsonIgnore
    private OperationResult result;

    protected Operation() {
    }

    protected Operation(TableSchema<E> tableSchema) {
        this.tableSchema = tableSchema;
    }

    public Operation(TableSchema<E> schema, String operation) {
        this.tableSchema = schema;
        this.op = operation;
    }

    public String getOp() {
        return this.op;
    }

    public void setOp(String op) {
        this.op = op;
    }

    public OperationResult getResult() {
        return this.result;
    }

    public void setResult(OperationResult result) {
        this.result = result;
    }

    public TableSchema<E> getTableSchema() {
        return this.tableSchema;
    }

    public void setTableSchema(TableSchema<E> tableSchema) {
        this.tableSchema = tableSchema;
    }

    @JsonProperty
    public String getTable() {
        return this.tableSchema == null ? null : this.tableSchema.getName();
    }

    public String toString() {
        return "Operation [op=" + this.op + ", result=" + this.result + "]";
    }
}

