/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.lib.operations;

import java.util.ArrayList;
import java.util.List;
import org.opendaylight.ovsdb.lib.notation.Condition;
import org.opendaylight.ovsdb.lib.operations.ConditionalOperation;
import org.opendaylight.ovsdb.lib.operations.Operation;
import org.opendaylight.ovsdb.lib.operations.Where;
import org.opendaylight.ovsdb.lib.schema.ColumnSchema;
import org.opendaylight.ovsdb.lib.schema.TableSchema;

public class Select<E extends TableSchema<E>>
extends Operation<E>
implements ConditionalOperation {
    public static final String SELECT = "select";
    private List<Condition> where = new ArrayList<Condition>();
    private List<String> columns = new ArrayList<String>();

    public Select on(TableSchema schema) {
        this.setTableSchema(schema);
        return this;
    }

    public Select(TableSchema<E> schema) {
        super(schema, SELECT);
    }

    public <D, C extends TableSchema<C>> Select<E> column(ColumnSchema<C, D> columnSchema) {
        this.columns.add(columnSchema.getName());
        return this;
    }

    public Where where(Condition condition) {
        this.where.add(condition);
        return new Where(this);
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public void setColumns(List<String> columns) {
        this.columns = columns;
    }

    @Override
    public void addCondition(Condition condition) {
        this.where.add(condition);
    }

    public List<Condition> getWhere() {
        return this.where;
    }

    public void setWhere(List<Condition> where) {
        this.where = where;
    }
}

