/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.lib.operations;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.ovsdb.lib.OvsdbClient;
import org.opendaylight.ovsdb.lib.operations.Operation;
import org.opendaylight.ovsdb.lib.operations.OperationResult;
import org.opendaylight.ovsdb.lib.schema.DatabaseSchema;
import org.opendaylight.ovsdb.lib.schema.typed.TypedBaseTable;
import org.opendaylight.ovsdb.lib.schema.typed.TyperUtils;

public class TransactionBuilder {
    private final List<Operation> operations = new ArrayList<Operation>();
    private final @NonNull DatabaseSchema databaseSchema;
    private final OvsdbClient ovs;

    public TransactionBuilder(OvsdbClient ovs, DatabaseSchema schema) {
        this.ovs = ovs;
        this.databaseSchema = Objects.requireNonNull(schema);
    }

    public List<Operation> getOperations() {
        return this.operations;
    }

    public TransactionBuilder add(Operation operation) {
        this.operations.add(operation);
        return this;
    }

    public List<Operation> build() {
        return this.operations;
    }

    public ListenableFuture<List<OperationResult>> execute() {
        return this.ovs.transact(this.databaseSchema, this.operations);
    }

    public @NonNull DatabaseSchema getDatabaseSchema() {
        return this.databaseSchema;
    }

    public <T extends TypedBaseTable<?>> T getTypedRowWrapper(Class<T> klazz) {
        return TyperUtils.getTypedRowWrapper(this.databaseSchema, klazz);
    }

    public <T extends TypedBaseTable<?>> T getTypedRowSchema(Class<T> klazz) {
        return TyperUtils.getTypedRowWrapper(this.databaseSchema, klazz, null);
    }
}

