/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.lib.operations;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opendaylight.ovsdb.lib.notation.Column;
import org.opendaylight.ovsdb.lib.notation.Condition;
import org.opendaylight.ovsdb.lib.notation.Row;
import org.opendaylight.ovsdb.lib.operations.ConditionalOperation;
import org.opendaylight.ovsdb.lib.operations.Operation;
import org.opendaylight.ovsdb.lib.operations.Where;
import org.opendaylight.ovsdb.lib.schema.ColumnSchema;
import org.opendaylight.ovsdb.lib.schema.TableSchema;
import org.opendaylight.ovsdb.lib.schema.typed.TypedBaseTable;

public class Update<E extends TableSchema<E>>
extends Operation<E>
implements ConditionalOperation {
    public static final String UPDATE = "update";
    private final Map<String, Object> row = new HashMap<String, Object>();
    private String uuid;
    private final List<Condition> where = new ArrayList<Condition>();
    private String uuidName;

    public Update(TableSchema<E> schema) {
        super(schema, UPDATE);
    }

    public Update<E> on(TableSchema schema) {
        return this;
    }

    public Update(TableSchema<E> schema, Row<E> row) {
        super(schema, UPDATE);
        Collection<Column<E, ?>> columns = row.getColumns();
        for (Column<E, ?> column : columns) {
            this.set(column);
        }
    }

    public Update(TypedBaseTable<E> typedTable) {
        this((TableSchema<E>)typedTable.getSchema(), typedTable.getRow());
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"})
    public <T extends TableSchema<T>, D> Update<E> set(ColumnSchema<T, D> columnSchema, D value) {
        columnSchema.validate(value);
        Object untypedValue = columnSchema.getNormalizeData(value);
        this.row.put(columnSchema.getName(), untypedValue);
        return this;
    }

    public <T extends TableSchema<T>, D> Update<E> set(Column<T, D> column) {
        ColumnSchema<T, D> columnSchema = column.getSchema();
        D value = column.getData();
        return this.set(columnSchema, value);
    }

    public Where where(Condition condition) {
        this.where.add(condition);
        return new Where(this);
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getUuidName() {
        return this.uuidName;
    }

    public void setUuidName(String uuidName) {
        this.uuidName = uuidName;
    }

    public Map<String, Object> getRow() {
        return this.row;
    }

    public void setRow(Map<String, Object> row) {
        this.row.clear();
        this.row.putAll(row);
    }

    @Override
    public void addCondition(Condition condition) {
        this.where.add(condition);
    }

    public List<Condition> getWhere() {
        return this.where;
    }

    public void setWhere(List<Condition> where) {
        this.where.clear();
        this.where.addAll(where);
    }
}

