/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.lib.schema;

import com.fasterxml.jackson.databind.JsonNode;
import org.opendaylight.ovsdb.lib.notation.OvsdbSet;
import org.opendaylight.ovsdb.lib.schema.BaseType;
import org.opendaylight.ovsdb.lib.schema.ColumnType;

final class AtomicColumnType
extends ColumnType {
    AtomicColumnType(BaseType baseType) {
        super(baseType, 1L, 1L);
    }

    AtomicColumnType(BaseType baseType, long min, long max) {
        super(baseType, min, max);
    }

    static AtomicColumnType fromJsonNode(JsonNode json) {
        if (json.isObject() && json.has("value")) {
            return null;
        }
        BaseType jsonBaseType = BaseType.fromJson(json, "key");
        return jsonBaseType == null ? null : new AtomicColumnType(jsonBaseType, AtomicColumnType.minFromJson(json), AtomicColumnType.maxFromJson(json));
    }

    @Override
    public Object valueFromJson(JsonNode value) {
        if (this.isMultiValued()) {
            OvsdbSet result = new OvsdbSet();
            if (value.isArray()) {
                if (value.size() == 2) {
                    if (value.get(0).isTextual() && "set".equals(value.get(0).asText())) {
                        for (JsonNode node : value.get(1)) {
                            result.add(this.getBaseType().toValue(node));
                        }
                    } else {
                        result.add(this.getBaseType().toValue(value));
                    }
                }
            } else {
                result.add(this.getBaseType().toValue(value));
            }
            return result;
        }
        return this.getBaseType().toValue(value);
    }
}

