/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.lib.schema;

import com.fasterxml.jackson.databind.JsonNode;
import org.opendaylight.ovsdb.lib.error.TyperException;
import org.opendaylight.ovsdb.lib.schema.BaseTypeFactory;
import org.opendaylight.ovsdb.lib.schema.BooleanBaseType;
import org.opendaylight.ovsdb.lib.schema.IntegerBaseType;
import org.opendaylight.ovsdb.lib.schema.RealBaseType;
import org.opendaylight.ovsdb.lib.schema.StringBaseType;
import org.opendaylight.ovsdb.lib.schema.UuidBaseType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseType<E extends BaseType<E>> {
    private static final Logger LOG = LoggerFactory.getLogger(BaseType.class);

    BaseType() {
    }

    public static BaseType fromJson(JsonNode json, String keyorval) {
        BaseTypeFactory<?> factory;
        JsonNode typeName;
        if (json.isValueNode()) {
            return BaseType.singletonFor(json.asText().trim());
        }
        JsonNode type = json.get(keyorval);
        if (type == null) {
            throw new TyperException("Not a type");
        }
        if (type.isTextual()) {
            return BaseType.singletonFor(type.asText());
        }
        if (type.isObject() && (typeName = type.get("type")) != null && (factory = BaseType.factoryFor(typeName.asText())) != null) {
            return factory.create(type);
        }
        return null;
    }

    public abstract Object toValue(JsonNode var1);

    public abstract void validate(Object var1);

    private static BaseType singletonFor(String type) {
        switch (type) {
            case "boolean": {
                return BooleanBaseType.SINGLETON;
            }
            case "integer": {
                return IntegerBaseType.SINGLETON;
            }
            case "real": {
                return RealBaseType.SINGLETON;
            }
            case "string": {
                return StringBaseType.SINGLETON;
            }
            case "uuid": {
                return UuidBaseType.SINGLETON;
            }
        }
        LOG.debug("Unknown base type {}", (Object)type);
        return null;
    }

    private static BaseTypeFactory<?> factoryFor(String type) {
        switch (type) {
            case "boolean": {
                return BooleanBaseType.FACTORY;
            }
            case "integer": {
                return IntegerBaseType.FACTORY;
            }
            case "real": {
                return RealBaseType.FACTORY;
            }
            case "string": {
                return StringBaseType.FACTORY;
            }
            case "uuid": {
                return UuidBaseType.FACTORY;
            }
        }
        LOG.debug("Unknown base type {}", (Object)type);
        return null;
    }
}

