/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.lib.schema;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opendaylight.ovsdb.lib.error.BadSchemaException;
import org.opendaylight.ovsdb.lib.notation.Condition;
import org.opendaylight.ovsdb.lib.notation.Function;
import org.opendaylight.ovsdb.lib.notation.OvsdbMap;
import org.opendaylight.ovsdb.lib.notation.OvsdbSet;
import org.opendaylight.ovsdb.lib.schema.ColumnType;
import org.opendaylight.ovsdb.lib.schema.TableSchema;

public class ColumnSchema<E extends TableSchema<E>, D> {
    private final String name;
    private final ColumnType type;

    public ColumnSchema(String name, ColumnType columnType) {
        this.name = name;
        this.type = columnType;
    }

    public static <E extends TableSchema<E>, D> ColumnSchema<E, D> fromJson(String name, JsonNode json) {
        if (!json.isObject()) {
            throw new BadSchemaException("bad column schema root, expected an object");
        }
        JsonNode type = json.get("type");
        if (type == null) {
            throw new BadSchemaException("bad column schema root, expected \"type\" as child");
        }
        return new ColumnSchema<E, D>(name, ColumnType.fromJson(type));
    }

    public String getName() {
        return this.name;
    }

    public ColumnType getType() {
        return this.type;
    }

    public Condition opEqual(D data) {
        return new Condition(this.getName(), Function.EQUALS, data);
    }

    public Condition opGreaterThan(D data) {
        return new Condition(this.getName(), Function.GREATER_THAN, data);
    }

    public Condition opLesserThan(D data) {
        return new Condition(this.getName(), Function.GREATER_THAN, data);
    }

    public Condition opLesserThanOrEquals(D data) {
        return new Condition(this.getName(), Function.LESS_THAN_OR_EQUALS, data);
    }

    public Condition opIncludes(D data) {
        return new Condition(this.getName(), Function.INCLUDES, data);
    }

    public Condition opExcludes(D data) {
        return new Condition(this.getName(), Function.EXCLUDES, data);
    }

    public String toString() {
        return "ColumnSchema{name='" + this.name + "', type=" + this.type + "}";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnSchema other = (ColumnSchema)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type);
    }

    public D validate(Object value) {
        this.type.validate(value);
        return (D)value;
    }

    public void validateType(Class<?> typeClass) {
    }

    public D valueFromJson(JsonNode value) {
        return (D)this.getType().valueFromJson(value);
    }

    public Object getNormalizeData(D value) {
        Object untypedValue = value instanceof Set ? OvsdbSet.fromSet((Set)value) : (value instanceof Map ? OvsdbMap.fromMap((Map)value) : value);
        return untypedValue;
    }
}

