/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.lib.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableList;
import java.util.function.Function;
import org.opendaylight.ovsdb.lib.error.TyperException;
import org.opendaylight.ovsdb.lib.jsonrpc.JsonUtils;
import org.opendaylight.ovsdb.lib.schema.AtomicColumnType;
import org.opendaylight.ovsdb.lib.schema.BaseType;
import org.opendaylight.ovsdb.lib.schema.KeyValuedColumnType;

public abstract class ColumnType {
    private static final ImmutableList<Function<JsonNode, ColumnType>> FACTORIES = ImmutableList.of(AtomicColumnType::fromJsonNode, KeyValuedColumnType::fromJsonNode);
    private final BaseType baseType;
    private final long min;
    private final long max;

    ColumnType(BaseType baseType, long min, long max) {
        this.baseType = baseType;
        this.min = min;
        this.max = max;
    }

    public static ColumnType fromJson(JsonNode json) {
        for (Function factory : FACTORIES) {
            ColumnType columnType = (ColumnType)factory.apply(json);
            if (null == columnType) continue;
            return columnType;
        }
        throw new TyperException(String.format("could not find the right column type %s", JsonUtils.prettyString(json)));
    }

    public BaseType getBaseType() {
        return this.baseType;
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public boolean isMultiValued() {
        return this.min != this.max;
    }

    public abstract Object valueFromJson(JsonNode var1);

    public void validate(Object value) {
        this.baseType.validate(value);
    }

    public String toString() {
        return "ColumnType{baseType=" + this.baseType + ", min=" + this.min + ", max=" + this.max + "}";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.baseType == null ? 0 : this.baseType.hashCode());
        result = 31 * result + (int)(this.max ^ this.max >>> 32);
        result = 31 * result + (int)(this.min ^ this.min >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnType other = (ColumnType)obj;
        if (this.baseType == null ? other.baseType != null : !this.baseType.equals(other.baseType)) {
            return false;
        }
        if (this.max != other.max) {
            return false;
        }
        return this.min == other.min;
    }

    static long maxFromJson(JsonNode json) {
        JsonNode maxNode = json.get("max");
        if (maxNode != null) {
            if (maxNode.isLong()) {
                return maxNode.asLong();
            }
            if (maxNode.isTextual() && "unlimited".equals(maxNode.asText())) {
                return Long.MAX_VALUE;
            }
        }
        return 1L;
    }

    static long minFromJson(JsonNode json) {
        JsonNode minNode = json.get("min");
        return minNode == null ? 1L : minNode.asLong();
    }
}

