/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.lib.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.reflect.Invokable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opendaylight.ovsdb.lib.error.ParsingException;
import org.opendaylight.ovsdb.lib.notation.Version;
import org.opendaylight.ovsdb.lib.schema.DatabaseSchema;
import org.opendaylight.ovsdb.lib.schema.GenericTableSchema;
import org.opendaylight.ovsdb.lib.schema.TableSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VisibleForTesting
public class DatabaseSchemaImpl
implements DatabaseSchema {
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseSchemaImpl.class);
    private final String name;
    private final Version version;
    private final ImmutableMap<String, TableSchema> tables;

    public DatabaseSchemaImpl(String name, Version version, Map<String, TableSchema> tables) {
        this.name = Objects.requireNonNull(name);
        this.version = Objects.requireNonNull(version);
        this.tables = ImmutableMap.copyOf(tables);
    }

    public static DatabaseSchema fromJson(String dbName, JsonNode json) {
        if (!json.isObject() || !json.has("tables")) {
            throw new ParsingException("bad DatabaseSchema root, expected \"tables\" as child but was not found");
        }
        if (!json.isObject() || !json.has("version")) {
            throw new ParsingException("bad DatabaseSchema root, expected \"version\" as child but was not found");
        }
        Version dbVersion = Version.fromString(json.get("version").asText());
        HashMap<String, TableSchema> tables = new HashMap<String, TableSchema>();
        Iterator iter = json.get("tables").fields();
        while (iter.hasNext()) {
            Map.Entry table = (Map.Entry)iter.next();
            LOG.trace("Read schema for table[{}]:{}", table.getKey(), table.getValue());
            tables.put((String)table.getKey(), GenericTableSchema.fromJson((String)table.getKey(), (JsonNode)table.getValue()));
        }
        return new DatabaseSchemaImpl(dbName, dbVersion, tables);
    }

    @Override
    public Set<String> getTables() {
        return this.tables.keySet();
    }

    @Override
    public boolean hasTable(String table) {
        return this.tables.containsKey((Object)table);
    }

    @Override
    public <E extends TableSchema<E>> E table(String tableName, Class<E> clazz) {
        TableSchema table = (TableSchema)this.tables.get((Object)tableName);
        if (clazz.isInstance(table)) {
            return (E)((TableSchema)clazz.cast(table));
        }
        return this.createTableSchema(clazz, table);
    }

    protected <E extends TableSchema<E>> E createTableSchema(Class<E> clazz, TableSchema<E> table) {
        Constructor<E> declaredConstructor;
        try {
            declaredConstructor = clazz.getDeclaredConstructor(TableSchema.class);
        }
        catch (NoSuchMethodException e) {
            String message = String.format("Class %s does not have public constructor that accepts TableSchema object", clazz);
            throw new IllegalArgumentException(message, e);
        }
        Invokable invokable = Invokable.from(declaredConstructor);
        try {
            return (E)((TableSchema)invokable.invoke(null, new Object[]{table}));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            String message = String.format("Not able to create instance of class %s using public constructor that accepts TableSchema object", clazz);
            throw new IllegalArgumentException(message, e);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public DatabaseSchema withInternallyGeneratedColumns() {
        return this.haveInternallyGeneratedColumns() ? this : new DatabaseSchemaImpl(this.name, this.version, Maps.transformValues(this.tables, TableSchema::withInternallyGeneratedColumns));
    }

    protected final boolean haveInternallyGeneratedColumns() {
        for (TableSchema tableSchema : this.tables.values()) {
            if (tableSchema.haveInternallyGeneratedColumns()) continue;
            return false;
        }
        return true;
    }
}

