/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.lib.schema;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.opendaylight.ovsdb.lib.error.BadSchemaException;
import org.opendaylight.ovsdb.lib.schema.ColumnSchema;
import org.opendaylight.ovsdb.lib.schema.TableSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericTableSchema
extends TableSchema<GenericTableSchema> {
    private static final Logger LOG = LoggerFactory.getLogger(GenericTableSchema.class);

    public GenericTableSchema(String name) {
        super(name);
    }

    public GenericTableSchema(String name, Map<String, ColumnSchema> columns) {
        super(name, columns);
    }

    public GenericTableSchema(TableSchema tableSchema) {
        super(tableSchema.getName(), tableSchema.getColumnSchemas());
    }

    public static GenericTableSchema fromJson(String tableName, JsonNode json) {
        if (!json.isObject() || !json.has("columns")) {
            throw new BadSchemaException("bad tableschema root, expected \"columns\" as child");
        }
        HashMap<String, ColumnSchema> columns = new HashMap<String, ColumnSchema>();
        Iterator iter = json.get("columns").fields();
        while (iter.hasNext()) {
            Map.Entry column = (Map.Entry)iter.next();
            LOG.trace("fromJson() table/column = {}:{}", (Object)tableName, column.getKey());
            columns.put((String)column.getKey(), ColumnSchema.fromJson((String)column.getKey(), (JsonNode)column.getValue()));
        }
        return new GenericTableSchema(tableName, columns);
    }

    @Override
    public GenericTableSchema withInternallyGeneratedColumns() {
        if (this.haveInternallyGeneratedColumns()) {
            return this;
        }
        HashMap<String, ColumnSchema> columns = new HashMap<String, ColumnSchema>(this.getColumnSchemas());
        columns.put(UUID_COLUMN_SCHMEMA.getName(), UUID_COLUMN_SCHMEMA);
        columns.put(VERSION_COLUMN_SCHMEMA.getName(), VERSION_COLUMN_SCHMEMA);
        return new GenericTableSchema(this.getName(), columns);
    }
}

