/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.lib.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.opendaylight.ovsdb.lib.schema.BaseType;
import org.opendaylight.ovsdb.lib.schema.BaseTypeFactory;

final class IntegerBaseType
extends BaseType<IntegerBaseType> {
    static final IntegerBaseType SINGLETON = new IntegerBaseType(Long.MIN_VALUE, Long.MAX_VALUE, null);
    static final BaseTypeFactory<IntegerBaseType> FACTORY = new Factory();
    private final long min;
    private final long max;
    private final ImmutableSet<Integer> enums;

    IntegerBaseType(long min, long max, ImmutableSet<Integer> enums) {
        this.min = min;
        this.max = max;
        this.enums = enums;
    }

    @Override
    public Object toValue(JsonNode value) {
        return value.asLong();
    }

    @Override
    public void validate(Object value) {
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public Set<Integer> getEnums() {
        return this.enums;
    }

    public String toString() {
        return "IntegerBaseType";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.enums == null ? 0 : this.enums.hashCode());
        result = 31 * result + (int)(this.max ^ this.max >>> 32);
        result = 31 * result + (int)(this.min ^ this.min >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntegerBaseType other = (IntegerBaseType)obj;
        if (this.enums == null ? other.enums != null : !this.enums.equals(other.enums)) {
            return false;
        }
        if (this.max != other.max) {
            return false;
        }
        return this.min == other.min;
    }

    private static final class Factory
    extends BaseTypeFactory.WithEnum<IntegerBaseType, Integer> {
        private Factory() {
        }

        @Override
        IntegerBaseType create(JsonNode typeDefinition) {
            JsonNode typeMaxNode = typeDefinition.get("maxInteger");
            long max = typeMaxNode != null ? typeMaxNode.asLong() : Long.MAX_VALUE;
            JsonNode typeMinNode = typeDefinition.get("minInteger");
            long min = typeMinNode != null ? typeMinNode.asLong() : Long.MIN_VALUE;
            JsonNode typeEnumNode = typeDefinition.get("enum");
            ImmutableSet enums = typeEnumNode != null ? this.parseEnums(typeEnumNode) : null;
            return min == Long.MIN_VALUE && max == Long.MAX_VALUE && enums == null ? SINGLETON : new IntegerBaseType(min, max, enums);
        }

        @Override
        Integer getEnumValue(JsonNode jsonEnum) {
            return jsonEnum.asInt();
        }
    }
}

