/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.lib.schema;

import com.fasterxml.jackson.databind.JsonNode;
import org.opendaylight.ovsdb.lib.notation.OvsdbMap;
import org.opendaylight.ovsdb.lib.schema.BaseType;
import org.opendaylight.ovsdb.lib.schema.ColumnType;

final class KeyValuedColumnType
extends ColumnType {
    private final BaseType keyType;

    private KeyValuedColumnType(BaseType keyType, BaseType valueType, long min, long max) {
        super(valueType, min, max);
        this.keyType = keyType;
    }

    static KeyValuedColumnType fromJsonNode(JsonNode json) {
        if (json.isValueNode() || !json.has("value")) {
            return null;
        }
        BaseType jsonKeyType = BaseType.fromJson(json, "key");
        BaseType valueType = BaseType.fromJson(json, "value");
        return new KeyValuedColumnType(jsonKeyType, valueType, KeyValuedColumnType.minFromJson(json), KeyValuedColumnType.maxFromJson(json));
    }

    @Override
    public Object valueFromJson(JsonNode node) {
        if (node.isArray() && node.size() == 2) {
            if (node.get(0).isTextual() && "map".equals(node.get(0).asText())) {
                OvsdbMap map = new OvsdbMap();
                for (JsonNode pairNode : node.get(1)) {
                    if (!pairNode.isArray() || node.size() != 2) continue;
                    Object key = this.keyType.toValue(pairNode.get(0));
                    Object value = this.getBaseType().toValue(pairNode.get(1));
                    map.put(key, value);
                }
                return map;
            }
            if (node.size() == 0) {
                return null;
            }
        }
        return null;
    }

    @Override
    public String toString() {
        return "KeyValuedColumnType [keyType=" + this.keyType + " " + super.toString() + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.keyType == null ? 0 : this.keyType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KeyValuedColumnType other = (KeyValuedColumnType)obj;
        return !(this.keyType == null ? other.keyType != null : !this.keyType.equals(other.keyType));
    }
}

