/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.ovsdb.lib.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.opendaylight.ovsdb.lib.schema.BaseType;
import org.opendaylight.ovsdb.lib.schema.BaseTypeFactory;

final class RealBaseType
extends BaseType<RealBaseType> {
    static final RealBaseType SINGLETON = new RealBaseType(Double.MIN_VALUE, Double.MAX_VALUE, null);
    static final BaseTypeFactory<RealBaseType> FACTORY = new Factory();
    private final double min;
    private final double max;
    private final ImmutableSet<Double> enums;

    RealBaseType(double min, double max, ImmutableSet<Double> enums) {
        this.min = min;
        this.max = max;
        this.enums = enums;
    }

    @Override
    public Object toValue(JsonNode value) {
        return value.asDouble();
    }

    @Override
    public void validate(Object value) {
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public Set<Double> getEnums() {
        return this.enums;
    }

    public String toString() {
        return "RealBaseType";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.enums == null ? 0 : this.enums.hashCode());
        long temp = Double.doubleToLongBits(this.max);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.min);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RealBaseType other = (RealBaseType)obj;
        if (this.enums == null ? other.enums != null : !this.enums.equals(other.enums)) {
            return false;
        }
        if (Double.doubleToLongBits(this.max) != Double.doubleToLongBits(other.max)) {
            return false;
        }
        return Double.doubleToLongBits(this.min) == Double.doubleToLongBits(other.min);
    }

    private static final class Factory
    extends BaseTypeFactory.WithEnum<RealBaseType, Double> {
        private Factory() {
        }

        @Override
        RealBaseType create(JsonNode typeDefinition) {
            JsonNode typeMaxNode = typeDefinition.get("maxReal");
            double max = typeMaxNode != null ? (double)typeMaxNode.asLong() : Double.MAX_VALUE;
            JsonNode typeMinNode = typeDefinition.get("minReal");
            double min = typeMinNode != null ? (double)typeMinNode.asLong() : Double.MIN_VALUE;
            JsonNode typeEnumNode = typeDefinition.get("enum");
            ImmutableSet enums = typeEnumNode != null ? this.parseEnums(typeEnumNode) : null;
            return typeMinNode == null && typeMaxNode == null && enums == null ? SINGLETON : new RealBaseType(min, max, enums);
        }

        @Override
        Double getEnumValue(JsonNode jsonEnum) {
            return jsonEnum.asDouble();
        }
    }
}

